/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.main;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

import javax.swing.JTabbedPane;

/**
 * @author sima
 * 
 */
public class TabbedPaneMousePointer extends MouseMotionAdapter {
	private volatile int x;
	private volatile int y;
	final private JTabbedPane jTabbedPane;

	public TabbedPaneMousePointer(JTabbedPane jTabbedPane) {
		this.jTabbedPane = jTabbedPane;
		jTabbedPane.addMouseMotionListener(this);
	}

	@Override
	public void mouseMoved(MouseEvent e) {
		x = e.getX();
		y = e.getY();
	}

	public int getFocusedComponentIndex() {
		int indexAtLocation = jTabbedPane.indexAtLocation(x, y);
		return indexAtLocation;
	}

}
