/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService;

import java.sql.Types;

public enum ConstSqlTypes {
	JDBC("JDBCの取得値に従う", Integer.MAX_VALUE - 1, Categoly.SPECIAL), UNUSE("未指定", Integer.MAX_VALUE, Categoly.SPECIAL),

	ARRAY("Types.ARRAY", Types.ARRAY, Categoly.SPECIAL), BIGINT("Types.BIGINT", Types.BIGINT, Categoly.NUM), BINARY(
	        "Types.BINARY", Types.BINARY, Categoly.BIN), BIT("Types.BIT", Types.BIT, Categoly.BIT), BLOB("Types.BLOB",
	        Types.BLOB, Categoly.BIN), BOOLEAN("Types.BOOLEAN", Types.BOOLEAN, Categoly.BIT), CHAR("Types.CHAR",
	        Types.CHAR, Categoly.CHAR), CLOB("Types.CLOB", Types.CLOB, Categoly.CHAR), DATALINK("Types.DATALINK",
	        Types.DATALINK, Categoly.SPECIAL), DATE("Types.DATE", Types.DATE, Categoly.DAYTIME), DECIMAL(
	        "Types.DECIMAL", Types.DECIMAL, Categoly.NUM), DISTINCT("Types.DISTINCT", Types.DISTINCT, Categoly.SPECIAL), DOUBLE(
	        "Types.DOUBLE", Types.DOUBLE, Categoly.NUM), FLOAT("Types.FLOAT", Types.FLOAT, Categoly.NUM), INTEGER(
	        "Types.INTEGER", Types.INTEGER, Categoly.NUM), JAVA_OBJECT("Types.JAVA_OBJECT", Types.JAVA_OBJECT,
	        Categoly.SPECIAL), LONGVARBINARY("Types.LONGVARBINARY", Types.LONGVARBINARY, Categoly.BIN), LONGVARCHAR(
	        "Types.LONGVARCHAR", Types.LONGVARCHAR, Categoly.CHAR), NULL("Types.NULL", Types.NULL, Categoly.SPECIAL), NUMERIC(
	        "Types.NUMERIC", Types.NUMERIC, Categoly.NUM), OTHER("Types.OTHER", Types.OTHER, Categoly.SPECIAL), REAL(
	        "Types.REAL", Types.REAL, Categoly.NUM), REF("Types.REF", Types.REF, Categoly.SPECIAL), SMALLINT(
	        "Types.SMALLINT", Types.SMALLINT, Categoly.NUM), STRUCT("Types.STRUCT", Types.STRUCT, Categoly.SPECIAL), TIME(
	        "Types.TIME", Types.TIME, Categoly.DAYTIME), TIMESTAMP("Types.TIMESTAMP", Types.TIMESTAMP, Categoly.DAYTIME), TINYINT(
	        "Types.TINYINT", Types.TINYINT, Categoly.DAYTIME), VARBINARY("Types.VARBINARY", Types.VARBINARY,
	        Categoly.BIN), VARCHAR("Types.VARCHAR", Types.VARCHAR, Categoly.CHAR), ;

	private final String name;

	private int value;

	private final Categoly categoly;

	ConstSqlTypes(String name, int value, Categoly categoly) {
		this.name = name;
		this.value = value;
		this.categoly = categoly;
	}

	@Override
	public String toString() {
		return name;
	}

	public int getValue() {
		return value;
	}

	public Categoly getCategoly() {
		return categoly;
	}

	public static ConstSqlTypes searchName(String name) {
		for (ConstSqlTypes i : ConstSqlTypes.values()) {
			if (i.toString().equals(name)) {
				return i;
			}
		}
		return UNUSE;
	}

	public static ConstSqlTypes searchTypes(int value) {
		for (ConstSqlTypes i : ConstSqlTypes.values()) {
			if (i.getValue() == value) {
				return i;
			}
		}
		return OTHER;
	}

	public static String getEnumName() {
		return "SqlTypes";
	}

	public enum Categoly {
		CHAR, BIT, BIN, NUM, DAYTIME, SPECIAL;
	}
}
