/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService;

/**
 * データベース接続開始終了のイベント通知するリスナーです。
 * 
 * @author sima
 * 
 */
public interface DataBaseConnectionListener extends DataBaseListener {

	/**
	 * データベース接続開始の通知
	 * 
	 * @param dataBaseConnection
	 */
	void dataBaseConnectionOpened(DataBaseConnection dataBaseConnection);

	/**
	 * データベース接続終了を開始する通知
	 */
	void dataBaseConnectionClosing(DataBaseConnection dataBaseConnection);

	/**
	 * データベース接続終了した事の通知
	 */
	void dataBaseConnectionClosed(DataBaseConnection dataBaseConnection);

}
