/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jdbcacsess2.sqlService;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author sima
 *
 */
public class ReferenceColumnResult {
	static public List<ReferenceColumnResult> convReferenceColumnResult(ResultSet rs) throws SQLException {
		List<ReferenceColumnResult> l = new ArrayList<ReferenceColumnResult>();
		while (rs.next()) {
			l.add(new ReferenceColumnResult(rs));
		}
		return l;
	}

	public ReferenceColumnResult(ResultSet rs) throws SQLException {
		int i = 0;
		int cnt = rs.getMetaData().getColumnCount();

		if (i < cnt)
			pktableCat = rs.getString(++i);
		if (i < cnt)
			pktableSchem = rs.getString(++i);
		if (i < cnt)
			pktableName = rs.getString(++i);
		if (i < cnt)
			pkcolumnName = rs.getString(++i);

		if (i < cnt)
			fktableCat = rs.getString(++i);
		if (i < cnt)
			fktableSchem = rs.getString(++i);
		if (i < cnt)
			fktableName = rs.getString(++i);
		if (i < cnt)
			fkcolumnName = rs.getString(++i);

		if (i < cnt)
			keySeq = rs.getShort(++i);
		if (i < cnt)
			updateRule = rs.getShort(++i);
		if (i < cnt)
			deleteRule = rs.getShort(++i);

		if (i < cnt)
			fkName = rs.getString(++i);
		if (i < cnt)
			pkName = rs.getString(++i);

		if (i < cnt)
			deferrability = rs.getShort(++i);
	}


	private String pktableCat;
	private String pktableSchem;
	private String pktableName;
	private String pkcolumnName;

	private String fktableCat;
	private String fktableSchem;
	private String fktableName;
	private String fkcolumnName;

	private Short keySeq;
	private Short updateRule;
	private Short deleteRule;

	private String fkName;
	private String pkName;

	private Short deferrability;

	public String getPktableCat() {
		return (pktableCat == null ? "" : pktableCat);
	}

	public String getPktableSchem() {
		return (pktableSchem == null ? "" : pktableSchem);
	}

	public String getPktableName() {
		return pktableName;
	}

	public String getPkcolumnName() {
		return pkcolumnName;
	}

	public String getFktableCat() {
		return (fktableCat == null ? "" : fktableCat);
	}

	public String getFktableSchem() {
		return (fktableSchem == null ? "" : fktableSchem);
	}

	public String getFktableName() {
		return fktableName;
	}

	public String getFkcolumnName() {
		return fkcolumnName;
	}

	public Short getKeySeq() {
		return keySeq;
	}

	public Short getUpdateRule() {
		return updateRule;
	}

	public String getUpdateRuleName() {
		switch (updateRule) {
		case DatabaseMetaData.importedKeyNoAction:
			return "NoAction";
		case DatabaseMetaData.importedKeyCascade:
			return "Cascade";
		case DatabaseMetaData.importedKeySetNull:
			return "SetNull";
		case DatabaseMetaData.importedKeySetDefault:
			return "SetDefault";
		case DatabaseMetaData.importedKeyRestrict:
			return "Restrict";
		}
		return "";
	}


	public Short getDeleteRule() {
		return deleteRule;
	}

	public String getDeleteRuleName() {
		switch (deleteRule) {
		case DatabaseMetaData.importedKeyNoAction:
			return "NoAction";
		case DatabaseMetaData.importedKeyCascade:
			return "Cascade";
		case DatabaseMetaData.importedKeySetNull:
			return "SetNull";
		case DatabaseMetaData.importedKeySetDefault:
			return "SetDefault";
		case DatabaseMetaData.importedKeyRestrict:
			return "Restrict";
		}
		return "";
	}

	public String getFkName() {
		return (fkName == null ? "" : fkName);
	}

	public String getPkName() {
		return (pkName == null ? "" : pkName);
	}

	public Short getDeferrability() {
		return deferrability;
	}

	public String getDeferrabilityName() {
		switch (deferrability) {
		case DatabaseMetaData.importedKeyInitiallyDeferred:
			return "InitiallyDeferred";
		case DatabaseMetaData.importedKeyInitiallyImmediate:
			return "InitiallyImmediate";
		case DatabaseMetaData.importedKeyNotDeferrable:
			return "NotDeferrable";
		}
		;

		return "";
	}

	@Override
	public String toString() {
		return "pktableName:" + pktableName + " pkcolumnName:" + pkcolumnName + " fktableName:" + fktableName
		       + " fkcolumnName:" + fkcolumnName;
	}

}
