/*
 * Copyright 2011 Kazuhiro Shimada
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *	    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jdbcacsess2.sqlService.dbobject;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.Icon;

import jdbcacsess2.main.Jdbcacsess2;
import jdbcacsess2.sqlService.dbobject.DBObjectCatalogs.DBObjectCatalog;
import jdbcacsess2.sqlService.dbobject.DBObjectSchemas.DBObjectSchema;
import jdbcacsess2.sqlService.dbobject.icon.DbObjectIconImage;

/**
 * TEBLETYPEの一覧
 * 
 * @author sima
 * 
 */
public class DBObjectTableTypes extends DBObjects {


	private final ArrayList<DBObjectTableType> tableTypes = new ArrayList<DBObjectTableType>();

	private final DBObjectCatalog dbCatalog;
	private final DBObjectSchema dbObjectSchema;

	/**
	 * コンストラクタ
	 * 
	 * @param schema
	 * @param dmd
	 * @throws SQLException
	 */
	public DBObjectTableTypes(DBObjectCatalog catalog, DBObjectSchema schema, DatabaseMetaData dmd)
			throws SQLException {
		dbCatalog = catalog;
		dbObjectSchema = schema;

		ResultSet rs = dmd.getTableTypes();
		while (rs.next()) {
			tableTypes.add(new DBObjectTableType(rs));
		}
		rs.close();
		tableTypes.add(new DBObjectTableTypeProcedure("PROCEDURE"));
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see jdbcacsess2.sqlService.dbobject.DBObjects#getDBObjects()
	 */
	@Override
	public ArrayList<? extends DBObject> getDBObjects() {
		return tableTypes;
	}

	/*
	 * (非 Javadoc)
	 * 
	 * @see jdbcacsess2.sqlService.dbobject.DBObjects#toString()
	 */
	@Override
	public String toString() {
		return "TABLETYPE";
	}

	/**
	 * TABLETYPEのプロパティ
	 * 
	 * @author sima
	 * 
	 */
	public class DBObjectTableType extends DBObject {

		public DBObjectTableType(String typeName) {
			tableTypeName = typeName;
		}

		public DBObjectTableType(ResultSet rs) {
			try {
				int colCnt = rs.getMetaData().getColumnCount();
				int i = 0;
				if (colCnt > i) {
					tableTypeName = rs.getString(++i);
					properties.add(new Property("TABLE_TYPE", tableTypeName));
				}
			} catch (SQLException e) {
				Jdbcacsess2.logger.warning(e.toString());
			}
		}

		private final List<Property> properties = new ArrayList<Property>();

		@Override
		public List<Property> getProperties() {
			return properties;
		}

		/**
		 * テーブルタイプ名 {@link DatabaseMetaData#getTableTypes}の第１要素
		 */
		public String tableTypeName;

		/*
		 * (非 Javadoc)
		 * 
		 * @seejdbcacsess2.sqlService.dbobject.DBObject#getChildren(java.sql.
		 * DatabaseMetaData)
		 */
		@Override
		public DBObjects getChildren(DatabaseMetaData dmd) throws SQLException {
			return new DBObjectTables(dbCatalog, dbObjectSchema, this, dmd);
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#getName()
		 */
		@Override
		public String getName() {
			return null;
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#getIconImage()
		 */
		@Override
		public Icon getIconImage() {
			return DbObjectIconImage.TABLETYPE.getValue();
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#isStrong()
		 */
		@Override
		public boolean isStrong() {
			return false;
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#isBottom()
		 */
		@Override
		public boolean isBottom() {
			return false;
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @see jdbcacsess2.sqlService.dbobject.DBObject#getSummary()
		 */
		@Override
		public String getSummary() {
			return tableTypeName;
		}

		@Override
		public boolean isPropertyEnable() {
			return false;
		}

	}

	/**
	 * TABLETYPEのプロパティ
	 * 
	 * @author sima
	 * 
	 */
	public class DBObjectTableTypeProcedure extends DBObjectTableType {

		DBObjectTableTypeProcedure(String name) {
			super(name);
		}

		/*
		 * (非 Javadoc)
		 * 
		 * @seejdbcacsess2.sqlService.dbobject.DBObject#getChildren(java.sql.
		 * DatabaseMetaData)
		 */
		@Override
		public DBObjects getChildren(DatabaseMetaData dmd) throws SQLException {
			return new DBObjectProcedures(dbCatalog, dbObjectSchema, dmd);
		}

	}

}
