/* 
 *    Copyright 2013 Mimisuke
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.awt.Image;
import java.io.IOException;
import javax.imageio.*;

public class Tarinai extends Body implements java.io.Serializable {
	static final long serialVersionUID = 1L;
	public static final int type = 4;
	public static final String nameJ = "たりないゆ";
	public static final String nameE = "Tarinaiyu";

	private static Image[][][] images = new Image[NUM_OF_CONDITIONS][2][3];

	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/tarinai/";

		// left face
		images[BODY][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/body.png"));
		images[LICK][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/lick.png"));
		images[BRAID][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"blank.png"));
		images[ACCESSORY][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"blank.png"));
		images[DAMAGED][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/damage.png"));
		images[PANTS][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/pants.png"));
		images[STAIN][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/shit.png"));
		images[SICK][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/sick.png"));
		images[NORMAL][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/normal.png"));
		images[SLEEPING][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/faces/sleeping.png"));
		images[CHEER][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/smile.png"));
		images[SMILE][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/smile.png"));
		images[TIRED][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/normal.png"));
		images[PUFF][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/normal.png"));
		images[CRYING][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/crying.png"));
		images[EXCITING][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/faces/exciting.png"));
		images[REFRESHED][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/faces/refreshed.png"));
		images[DEAD][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/dead.png"));
		images[RUDE][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/normal.png"));
		// right face
		images[BODY][RIGHT][adultIndex] =		flipImage(images[BODY][LEFT][adultIndex]);
		images[LICK][RIGHT][adultIndex] =		flipImage(images[LICK][LEFT][adultIndex]);
		images[BRAID][RIGHT][adultIndex] =		flipImage(images[BRAID][LEFT][adultIndex]);
		images[ACCESSORY][RIGHT][adultIndex] =	flipImage(images[ACCESSORY][LEFT][adultIndex]);
		images[DAMAGED][RIGHT][adultIndex] =	flipImage(images[DAMAGED][LEFT][adultIndex]);
		images[PANTS][RIGHT][adultIndex] =		flipImage(images[PANTS][LEFT][adultIndex]);
		images[STAIN][RIGHT][adultIndex] =		flipImage(images[STAIN][LEFT][adultIndex]);
		images[SICK][RIGHT][adultIndex] =		flipImage(images[SICK][LEFT][adultIndex]);		
		images[NORMAL][RIGHT][adultIndex] =		flipImage(images[NORMAL][LEFT][adultIndex]);
		images[SLEEPING][RIGHT][adultIndex] =	flipImage(images[SLEEPING][LEFT][adultIndex]);
		images[CHEER][RIGHT][adultIndex] =		flipImage(images[CHEER][LEFT][adultIndex]);
		images[SMILE][RIGHT][adultIndex] =		flipImage(images[SMILE][LEFT][adultIndex]);
		images[TIRED][RIGHT][adultIndex] =		flipImage(images[TIRED][LEFT][adultIndex]);
		images[PUFF][RIGHT][adultIndex] =		flipImage(images[PUFF][LEFT][adultIndex]);
		images[CRYING][RIGHT][adultIndex] =		flipImage(images[CRYING][LEFT][adultIndex]);
		images[EXCITING][RIGHT][adultIndex] =	flipImage(images[EXCITING][LEFT][adultIndex]);
		images[REFRESHED][RIGHT][adultIndex] =	flipImage(images[REFRESHED][LEFT][adultIndex]);
		images[DEAD][RIGHT][adultIndex] =		flipImage(images[DEAD][LEFT][adultIndex]);
		images[RUDE][RIGHT][adultIndex] =		flipImage(images[RUDE][LEFT][adultIndex]);		
		// center
		images[CRUSHED][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"crushed.png"));			
		images[CRUSHED2][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"crushed.png"));			
		images[SHIT][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"shit.png"));
		images[ROLL_ACCESSORY][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"blank.png"));
		images[ROLL_SHIT][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"roll_left.png"));
		images[ROLL_SHIT][RIGHT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"roll_right.png"));
		images[PANTS2][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"pants.png"));
		images[PANTS2_ROLL][LEFT][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+"left_pants.png"));
		images[PANTS2_ROLL][RIGHT][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+"right_pants.png"));

		for(Image[][] array2d : images) {	
			for(Image[] array : array2d) {
				if(array[adultIndex] == null) {
					continue;
				}
				// Scale larger images down
				array[adultIndex] = array[adultIndex].getScaledInstance(adultSize, adultSize, Image.SCALE_AREA_AVERAGING);
				array[childIndex] = array[adultIndex].getScaledInstance(childSize, childSize, Image.SCALE_AREA_AVERAGING);
				array[babyIndex] =  array[adultIndex].getScaledInstance(babySize, babySize, Image.SCALE_AREA_AVERAGING);
			}
		}
	}

	public Image getImage(int type, int direction) {
		return images[type][direction][ageState.ordinal()];
	}

	@Override
	public int getType() {
		return type;
	}

	@Override
	public int getHybridType(int partnerType) {
		switch (partnerType) {
		case Marisa.type:
			return MarisaReimu.type;
		default:
			return Tarinai.type;
		}
	}

	@Override
	public String getNameJ() {
		return nameJ;
	}

	@Override
	public String getNameE() {
		return nameE;
	}

	@Override
	protected String msgWantFoodJ () {
		return "ゆっぴー！";
	}

	@Override
	protected String msgWantFoodE () {
		return "Yuppi-!";
	}

	@Override
	protected String msgNoFoodJ()
	{
		return "ゆぅ-、、、";
	}

	@Override
	protected String msgNoFoodE()
	{
		return "Yuu,,,";
	}

	@Override
	protected String msgExciteJ() { return "ゆっぴぃー！"; }

	@Override
	protected String msgExciteE() { return "Yuppi-!"; }

	@Override
	protected String msgRelaxJ()
	{
		return "ゆーゆー";
	}

	@Override
	protected String msgRelaxE()
	{
		return "Yu-Yu-";
	}

	@Override
	protected String msgFuriFuriJ()
	{
		return "ゆっゆっ";
	}

	@Override
	protected String msgFuriFuriE()
	{
		return "YuYu";
	}

	protected String msgWakeupJ()
	{
		return "ゆぅーゆぅー";
	}

	protected String msgWakeupE()
	{
		return "Yu-Yu-";
	}

	@Override
	protected String msgSleepJ() { return "ゆーゆー"; }

	@Override
	protected String msgSleepE() { return "Yu-Yu-"; }

	@Override
	protected String msgScreamJ() {
		return "ゆっぴー！";
	}

	@Override
	protected String msgScreamE() {
		return "Yuppi-!";
	}

	@Override
	protected String msgScareJ () {
		return "ゆっぴー！";
	}
	
	@Override
	protected String msgScareE () {
		return "Yuppi-!";
	}

	@Override
	protected String msgScareRapistJ () {
		return "ゆっぴー！";	}

	@Override
	protected String msgScareRapistE () {
		return "Yuppi-!";
	}

	@Override
	protected String msgAlarmJ () {
		return "ゆぅー、、、";
	}

	@Override
	protected String msgAlarmE () {
		return "Yuu,,,,";
	}

	@Override
	protected String msgDyingJ () {
		return "ゆぴっ！";
	}

	@Override
	protected String msgDyingE () {
		return "Yuppi!";
	}

	@Override
	protected String msgDeadJ () {
		return "ゆ、ゆ、ゆ、、、";
	}

	@Override
	protected String msgDeadE () {
		return "Yu,Yu,Yu,,,";
	}

	@Override
	protected String msgEatingJ () {
		return "くっちゃくっちゃ";
	}

	@Override
	protected String msgEatingE () {
		return "Kucha,Kucha";
	}

	@Override
	protected String msgEatingShitJ () {
		return "くっちゃくっちゃ";
	}

	@Override
	protected String msgEatingShitE () {
		return "Kucha,Kucha";
	}
	
	@Override
	protected String msgEatingBitterJ () {
		return "くっちゃくっちゃ、、、ゆぴー！";
	}

	@Override
	protected String msgEatingBitterE () {
		return "Kuccha~Kuccha~,,,Yuppi-!";
	}

	@Override
	protected String msgFullJ () {
		return "ゆぴ";
	}

	@Override
	protected String msgFullE () {
		return "Yupi";
	}

	@Override
	protected String msgHealingJ () {
		return "ゆっぴー！";
	}

	@Override
	protected String msgHealingE () {
		return "Yuppi-!";
	}

	@Override
	protected String msgSukkiriJ () {
		return "ゆっぴー！";
	}

	@Override
	protected String msgSukkiriE () {
		return "Yuppi-!";
	}

	@Override
	protected String msgBirthJ () { return "ゆぴっゆぴっ！"; }

	@Override
	protected String msgBirthE () { return "Yuppi,Yuppi!"; }

	@Override
	protected String msgShitJ () {
		return "ゆぴ〜";
	}

	@Override
	protected String msgShitE () {
		return "Yupi~";
	}

	@Override
	protected String msgShit2J () {
		return "ゆっぴ〜！";
	}

	@Override
	protected String msgShit2E () {
		return "Yuppi~!";
	}
	
	@Override
	protected String msgSuriSuriJ () {
		return "ゆ〜ゆ〜ゆ〜";
	}

	@Override
	protected String msgSuriSuriE () {
		return "Yu~Yu~Yu~";
	}

	@Override
	protected String msgPeroPeroJ () {
		return "ゆーぴゃゆーぴゃ";
	}

	@Override
	protected String msgPeroPeroE () {
		return "Yu-pya,Yu-pya";
	}

	@Override
	protected String msgBreedJ() {
		return "ゆ、ゆ、、、";
	}

	@Override
	protected String msgBreedE() {
		return "Yu,Yu,,,";
	}

	@Override
	protected String msgBreed2J() {
		return "ゆっぴー！";
	}

	@Override
	protected String msgBreed2E() {
		return "Yuppi-!";
	}

	@Override
	protected String msgHateShitJ () {
		return "ゆぴー！";
	}

	@Override
	protected String msgHateShitE () {
		return "Yupi-!";
	}

	@Override
	protected String msgHungryJ () {
		return "ゆ、ゆ、ゆ";
	}

	@Override
	protected String msgHungryE () {
		return "Yu,Yu,Yu";
	}

	@Override
	protected String msgNoAccessoryJ () {
		return "";
	}

	@Override
	protected String msgNoAccessoryE () {
		return "";
	}

	@Override
	protected String msgHateYukkuriJ () {
		return "ゆっゆっゆっ";
	}

	@Override
	protected String msgHateYukkuriE () {
		return "YuYuYu";
	}

	@Override
	protected String msgFlyingJ () {
		return "ゆっぴゃー！";
	}

	@Override
	protected String msgFlyingE () {
		return "Yuppya-!";
	}

	@Override
	protected String msgSadnessForChildJ() {
		return "ゆぴ？";
	}

	@Override
	protected String msgSadnessForChildE() {
		return "Yupi?";
	}

	@Override
	protected String msgSadnessForPartnerJ (Body partner) {
		return "ゆぴ？";
	}

	@Override
	protected String msgSadnessForPartnerE (Body partner) {
		return "Yupi?";
	}
	
	@Override
	protected String msgSadnessForSisterJ (Body partner) {
		return "ゆぴ？";
	}

	@Override
	protected String msgSadnessForSisterE (Body partner) {
		return "Yupi?";
	}
	
	@Override
	protected String msgBlockedByWallJ () {
		return "ゆぴ？";
	}
	
	@Override
	protected String msgBlockedByWallE () {
		return "Yupi?";
	}
	
	@Override
	protected String msgGetTreasureJ () {
		String[] output = {"ゆぴ？", "ゆっぴー！", "ゆっぴー！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgGetTreasureE () {
		String[] output = {"Yupi?", "Yuppi-!", "Yuppi-!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgLostTreasureJ () {
		String[] output = {"ゆっぴー！", "ゆっぴー！", "ゆっぴー！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgLostTreasureE () {
		String[] output = {"Yuppi-!", "Yuppi-!", "Yuppi-!"};
		return output[ageState.ordinal()];
	}

	// public methods
	public Tarinai(int initX, int initY, int initZ, Body.AgeState initAgeState, Body p1, Body p2) {
		super(initX, initY, initZ, initAgeState, p1, p2);
	}
	
	public void tuneParameters() {
		hasAccessory = false;
		attitude = Attitude.SUPER_SHITHEAD;
		double factor = Math.random()*2+1;
		HUNGRYLIMIT[AgeState.ADULT.ordinal()] *= factor;
		HUNGRYLIMIT[AgeState.CHILD.ordinal()] *= factor;
		HUNGRYLIMIT[AgeState.BABY.ordinal()] *= factor;
		factor = Math.random()*2+1;
		SHITLIMIT[AgeState.ADULT.ordinal()] *= factor;
		SHITLIMIT[AgeState.CHILD.ordinal()] *= factor;
		SHITLIMIT[AgeState.BABY.ordinal()] *= factor;
		factor = Math.random()+0.5;
		DAMAGELIMIT[AgeState.ADULT.ordinal()] *= factor;
		DAMAGELIMIT[AgeState.CHILD.ordinal()] *= factor;
		DAMAGELIMIT[AgeState.BABY.ordinal()] *= factor;
		factor = Math.random()+0.5;
		BABYLIMIT *= factor;
		CHILDLIMIT *= factor;
		LIFELIMIT *= factor;
		factor = Math.random()+1;
		RELAXPERIOD *= factor;
		EXCITEPERIOD *= factor;
		PREGPERIOD *= factor;
		SLEEPPERIOD *= factor;
		ACTIVEPERIOD *= factor;
		sameDest = rnd.nextInt(20)+20;
		DECLINEPERIOD *= (Math.random()+0.5);
		DISCIPLINELIMIT *= (Math.random()+1);
		ROBUSTNESS = rnd.nextInt(2)+1;
		EYESIGHT /= 8;
		factor = Math.random()+1;
		STRENGTH[AgeState.ADULT.ordinal()] *= factor;
		STRENGTH[AgeState.CHILD.ordinal()] *= factor;
		STRENGTH[AgeState.BABY.ordinal()] *= factor;
	}
}