abstract class HybridBody<first extends Body, second extends Body> extends Body
{
	static final long serialVersionUID = 2L;

	public HybridBody(int initX, int initY, int initZ, AgeState initAgeState, Body p1, Body p2) {
		super(initX,initY,initZ,initAgeState,p1,p2);
	}

	public boolean isHybrid () { return true; }

	public int hybridType1 () {
		if (parents[Parent.PAPA.ordinal()] != null)
			return parents[Parent.PAPA.ordinal()].getType();
		else
			return rnd.nextInt(2);		
	}

	public int hybridType2 () {
		if (parents[Parent.MAMA.ordinal()] != null)
			return parents[Parent.MAMA.ordinal()].getType();
		else
			return rnd.nextInt(2);
	}

	public int getHybridType (int partnerType) {
		int type = rnd.nextInt(2);

		if (parents[type] != null) {
			return parents[type].getHybridType(partnerType);
		}
		else {
			return rnd.nextInt(2);
		}
	}
}