/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.datatransfer;

import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.harmony.awt.datatransfer.DataProvider;
import org.apache.harmony.awt.datatransfer.RawBitmap;
import org.apache.harmony.awt.internal.nls.Messages;

public final class DataProxy
implements Transferable {
    public static final Class[] unicodeTextClasses = new Class[]{String.class, Reader.class, CharBuffer.class, char[].class};
    public static final Class[] charsetTextClasses = new Class[]{byte[].class, ByteBuffer.class, InputStream.class};
    private final DataProvider data;
    private final SystemFlavorMap flavorMap;

    public DataProxy(DataProvider data) {
        this.data = data;
        this.flavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
    }

    public DataProvider getDataProvider() {
        return this.data;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        String mimeType = String.valueOf(flavor.getPrimaryType()) + "/" + flavor.getSubType();
        if (flavor.isFlavorTextType()) {
            if (mimeType.equalsIgnoreCase("text/html")) {
                return this.getHTML(flavor);
            }
            if (mimeType.equalsIgnoreCase("text/uri-list")) {
                return this.getURL(flavor);
            }
            return this.getPlainText(flavor);
        }
        if (flavor.isFlavorJavaFileListType()) {
            return this.getFileList(flavor);
        }
        if (flavor.isFlavorSerializedObjectType()) {
            return this.getSerializedObject(flavor);
        }
        if (flavor.equals(DataProvider.urlFlavor)) {
            return this.getURL(flavor);
        }
        if (mimeType.equalsIgnoreCase("image/x-java-image") && Image.class.isAssignableFrom(flavor.getRepresentationClass())) {
            return this.getImage(flavor);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        ArrayList<DataFlavor> result = new ArrayList<DataFlavor>();
        String[] natives = this.data.getNativeFormats();
        int i = 0;
        while (i < natives.length) {
            List<DataFlavor> flavors = this.flavorMap.getFlavorsForNative(natives[i]);
            for (DataFlavor f : flavors) {
                if (result.contains(f)) continue;
                result.add(f);
            }
            ++i;
        }
        return result.toArray(new DataFlavor[result.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        int i = 0;
        while (i < flavors.length) {
            if (flavors[i].equals(flavor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Object getPlainText(DataFlavor f) throws IOException, UnsupportedFlavorException {
        if (!this.data.isNativeFormatAvailable("text/plain")) {
            throw new UnsupportedFlavorException(f);
        }
        String str = this.data.getText();
        if (str == null) {
            throw new IOException(Messages.getString("awt.4F"));
        }
        return this.getTextRepresentation(str, f);
    }

    private Object getFileList(DataFlavor f) throws IOException, UnsupportedFlavorException {
        if (!this.data.isNativeFormatAvailable("application/x-java-file-list")) {
            throw new UnsupportedFlavorException(f);
        }
        String[] files = this.data.getFileList();
        if (files == null) {
            throw new IOException(Messages.getString("awt.4F"));
        }
        return Arrays.asList(files);
    }

    private Object getHTML(DataFlavor f) throws IOException, UnsupportedFlavorException {
        if (!this.data.isNativeFormatAvailable("text/html")) {
            throw new UnsupportedFlavorException(f);
        }
        String str = this.data.getHTML();
        if (str == null) {
            throw new IOException(Messages.getString("awt.4F"));
        }
        return this.getTextRepresentation(str, f);
    }

    private Object getURL(DataFlavor f) throws IOException, UnsupportedFlavorException {
        if (!this.data.isNativeFormatAvailable("application/x-java-url")) {
            throw new UnsupportedFlavorException(f);
        }
        String str = this.data.getURL();
        if (str == null) {
            throw new IOException(Messages.getString("awt.4F"));
        }
        URL url = new URL(str);
        if (f.getRepresentationClass().isAssignableFrom(URL.class)) {
            return url;
        }
        if (f.isFlavorTextType()) {
            return this.getTextRepresentation(url.toString(), f);
        }
        throw new UnsupportedFlavorException(f);
    }

    private Object getSerializedObject(DataFlavor f) throws IOException, UnsupportedFlavorException {
        String nativeFormat = SystemFlavorMap.encodeDataFlavor(f);
        if (nativeFormat == null || !this.data.isNativeFormatAvailable(nativeFormat)) {
            throw new UnsupportedFlavorException(f);
        }
        byte[] bytes = this.data.getSerializedObject(f.getRepresentationClass());
        if (bytes == null) {
            throw new IOException(Messages.getString("awt.4F"));
        }
        ByteArrayInputStream str = new ByteArrayInputStream(bytes);
        try {
            return new ObjectInputStream(str).readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private String getCharset(DataFlavor f) {
        return f.getParameter("charset");
    }

    private Object getTextRepresentation(String text, DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.getRepresentationClass() == String.class) {
            return text;
        }
        if (f.isRepresentationClassReader()) {
            return new StringReader(text);
        }
        if (f.isRepresentationClassCharBuffer()) {
            return CharBuffer.wrap(text);
        }
        if (f.getRepresentationClass() == char[].class) {
            char[] chars = new char[text.length()];
            text.getChars(0, text.length(), chars, 0);
            return chars;
        }
        String charset = this.getCharset(f);
        if (f.getRepresentationClass() == byte[].class) {
            byte[] bytes = text.getBytes(charset);
            return bytes;
        }
        if (f.isRepresentationClassByteBuffer()) {
            byte[] bytes = text.getBytes(charset);
            return ByteBuffer.wrap(bytes);
        }
        if (f.isRepresentationClassInputStream()) {
            byte[] bytes = text.getBytes(charset);
            return new ByteArrayInputStream(bytes);
        }
        throw new UnsupportedFlavorException(f);
    }

    private Image getImage(DataFlavor f) throws IOException, UnsupportedFlavorException {
        if (!this.data.isNativeFormatAvailable("image/x-java-image")) {
            throw new UnsupportedFlavorException(f);
        }
        RawBitmap bitmap = this.data.getRawBitmap();
        if (bitmap == null) {
            throw new IOException(Messages.getString("awt.4F"));
        }
        return this.createBufferedImage(bitmap);
    }

    private boolean isRGB(RawBitmap b) {
        return b.rMask == 0xFF0000 && b.gMask == 65280 && b.bMask == 255;
    }

    private boolean isBGR(RawBitmap b) {
        return b.rMask == 255 && b.gMask == 65280 && b.bMask == 0xFF0000;
    }

    private BufferedImage createBufferedImage(RawBitmap b) {
        if (b == null || b.buffer == null || b.width <= 0 || b.height <= 0) {
            return null;
        }
        ColorModel cm = null;
        WritableRaster wr = null;
        if (b.bits == 32 && b.buffer instanceof int[]) {
            if (!this.isRGB(b) && !this.isBGR(b)) {
                return null;
            }
            int[] masks = new int[]{b.rMask, b.gMask, b.bMask};
            int[] buffer = (int[])b.buffer;
            cm = new DirectColorModel(24, b.rMask, b.gMask, b.bMask);
            wr = Raster.createPackedRaster(new DataBufferInt(buffer, buffer.length), b.width, b.height, b.stride, masks, null);
        } else if (b.bits == 24 && b.buffer instanceof byte[]) {
            int[] offsets;
            int[] bits = new int[]{8, 8, 8};
            if (this.isRGB(b)) {
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                offsets = nArray;
            } else if (this.isBGR(b)) {
                int[] nArray = new int[3];
                nArray[0] = 2;
                nArray[1] = 1;
                offsets = nArray;
            } else {
                return null;
            }
            byte[] buffer = (byte[])b.buffer;
            cm = new ComponentColorModel(ColorSpace.getInstance(1000), bits, false, false, 1, 0);
            wr = Raster.createInterleavedRaster(new DataBufferByte(buffer, buffer.length), b.width, b.height, b.stride, 3, offsets, null);
        } else if ((b.bits == 16 || b.bits == 15) && b.buffer instanceof short[]) {
            int[] masks = new int[]{b.rMask, b.gMask, b.bMask};
            short[] buffer = (short[])b.buffer;
            cm = new DirectColorModel(b.bits, b.rMask, b.gMask, b.bMask);
            wr = Raster.createPackedRaster(new DataBufferUShort(buffer, buffer.length), b.width, b.height, b.stride, masks, null);
        }
        if (cm == null || wr == null) {
            return null;
        }
        return new BufferedImage(cm, wr, false, null);
    }
}

