package jp.ito.camera;

import java.util.Timer;
import java.util.TimerTask;

import android.app.Service;
import android.content.Intent;
import android.hardware.Camera;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.media.ToneGenerator;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import android.widget.Toast;

public class MainService extends Service {
	private static final String TAG = MainService.class.getSimpleName();
	public static final String BR_ACTION = "action";
	public static final String BR_TIMER = "timer";
	public static final String BR_XMPP = "xmpp";
	public static final String BR_XMPP_MESSAGE = "xmpp.message";
	public static final String BR_NOISE = "noise";
	public static final String BR_NOISE_DATA = "noise.data";
	public static final String BR_CAMERA = "camera";
	public static final String BR_SENSOR = "sensor";
	public static final String BR_SENSOR_DATA_X = "sensor.data.x";
	public static final String BR_SENSOR_DATA_Y = "sensor.data.y";
	public static final String BR_SENSOR_DATA_Z = "sensor.data.z";
	public static final String BR_TOAST = "toast";
	public static final String BR_TOAST_MESSAGE = "toast.message";
//	private	SurfaceHolder	_SurfaceHolder;
	private static XmppService		_xmppService = null;
	private static NoiseService		_noiseService = null;
	private static MailService		_mailService = null;
	private static CameraService	_cameraService = null;
	private static SensorService	_sensorService = null;

//	private MailService		_sendMail;

	class CameraBinder extends Binder {
		MainService getService() {
			return MainService.this;
		}
	}
	
	public static final String ACTION = "Camera Service";
	private Timer _timer;

	public MainService(){
		Log.d(TAG, "MainService()");
	}

	@Override
	public void onCreate() {
		Log.d(TAG, "onCreate()");
		super.onCreate();
		Toast toast = Toast.makeText(getApplicationContext(), "onCreate()", Toast.LENGTH_SHORT);
		toast.show();
		if ( _xmppService == null ){
			_xmppService = new XmppService(this);
		}
		if ( _noiseService == null ){
			_noiseService = new NoiseService(this);
			_noiseService.recordStart();
		}
		if ( _mailService == null ){
			_mailService = new MailService(this);
		}
		if ( _cameraService == null ){
			_cameraService = new CameraService(this);
		}
		if ( _sensorService == null ){
			_sensorService = new SensorService(this);
		}
	}
	
	@Override
	public void onStart(Intent intent, int startId) {
		Log.d(TAG, "onStart()");
		super.onStart(intent, startId);
		Toast toast = Toast.makeText(getApplicationContext(), "onStart()", Toast.LENGTH_SHORT);
		toast.show();
	}
	
	@Override
	public void onDestroy() {
		Log.d(TAG, "onDestroy()");
		super.onDestroy();
		Toast toast = Toast.makeText(getApplicationContext(), "onDestroy()", Toast.LENGTH_SHORT);
		toast.show();
		if (_timer != null) {
			_timer.cancel();
			_timer = null;
		}
	}
	
	@Override
	public IBinder onBind(Intent intent) {
		Log.d(TAG, "onBind()");
		Toast toast = Toast.makeText(getApplicationContext(), "onBind()", Toast.LENGTH_SHORT);
		toast.show();
		return new CameraBinder();
	}
	
	@Override
	public void onRebind(Intent intent) {
		Log.d(TAG, "onRebind()");
		Toast toast = Toast.makeText(getApplicationContext(), "onRebind()", Toast.LENGTH_SHORT);
		toast.show();
	}
	
	@Override
	public boolean onUnbind(Intent intent) {
		Log.d(TAG, "onUnbind()");
		Toast toast = Toast.makeText(getApplicationContext(), "onUnbind()", Toast.LENGTH_SHORT);
		toast.show();
		return true; // ēxNCAgڑꂽۂ onRebind Ăяoꍇ true Ԃ
	}
	
	// qT[rX̃R[obN
	public void toast(String str){
		Log.d(TAG, "toast(" + str + ")");
		Intent intent = new Intent(ACTION);
		intent.putExtra(BR_ACTION, BR_TOAST);
		intent.putExtra(BR_TOAST_MESSAGE, str);
		sendBroadcast(intent);
	}
	public void sendStatus(String msg){
		Log.d(TAG, "sendStatus()");
		Intent intent = new Intent(ACTION);
		intent.putExtra(BR_ACTION, BR_XMPP);
		intent.putExtra(BR_XMPP_MESSAGE, msg);
		sendBroadcast(intent);

		if ( msg.equals("camera") ){
	        ToneGenerator toneGenerator = new ToneGenerator(AudioManager.STREAM_SYSTEM, ToneGenerator.MAX_VOLUME);
	        toneGenerator.startTone(ToneGenerator.TONE_PROP_BEEP);   
			_cameraService.takePicture();
		} else if ( msg.equals("status") ){
	        ToneGenerator toneGenerator = new ToneGenerator(AudioManager.STREAM_SYSTEM, ToneGenerator.MAX_VOLUME);
	        toneGenerator.startTone(ToneGenerator.TONE_PROP_BEEP);   
	        String msg1 = _noiseService.getMessage();
	        String msg2 = _sensorService.getMessage();
	        _mailService.status(msg1, msg2);
		}
	}
	public void sendPhoto(String file){
		Log.d(TAG, "sendPhoto(" + file + ")");
        _mailService.photo(file);
	}
	public void setNoise(int data){
//		Log.d(TAG, "setNoise()");
		Intent intent = new Intent(ACTION);
		intent.putExtra(BR_ACTION, BR_NOISE);
		intent.putExtra(BR_NOISE_DATA, data);
		sendBroadcast(intent);
	}
	public void setSensor(int x, int y, int z){
//		Log.d(TAG, "setNoise()");
		Intent intent = new Intent(ACTION);
		intent.putExtra(BR_ACTION, BR_SENSOR);
		intent.putExtra(BR_SENSOR_DATA_X, x);
		intent.putExtra(BR_SENSOR_DATA_Y, y);
		intent.putExtra(BR_SENSOR_DATA_Z, z);
		sendBroadcast(intent);
	}
	// qT[rXւ̒ʒm
	public void xmppInit(String user, String password, String host, int port, String service){
		_xmppService.init(user, password, host, port, service);
	}
//	public void xmppFin(){
//		_xmppService.fin();
//	}
	// CANeBreBĂяo郁\bh
	public void schedule(long delay) {
		Log.d(TAG, "schedule()");
		if (_timer != null) {
			_timer.cancel();
		}
		_timer = new Timer();
		TimerTask timerTask = new TimerTask() {
			public void run() {
//				Intent intent = new Intent(ACTION);
//				intent.putExtra(BR_ACTION, BR_TIMER);
//				sendBroadcast(intent);
			}
		};
		_timer.schedule(timerTask, delay, delay);
	}
	public void getNoiseMessage(){
		String str = _noiseService.getMessage();
	}
	public void mailSetting(String address, String password, String host, String port){
		_mailService._address = address;
		_mailService._password = password;
		_mailService._host = host;
		_mailService._port = port;
	}
	public void sensorSetting(int levelX, int levelY, int levelZ, boolean beep){
		_sensorService._levelX = levelX;
		_sensorService._levelY = levelY;
		_sensorService._levelZ = levelZ;
		_sensorService._beep = beep;
	}
	public void OnSaveState(Bundle outState){
		_cameraService.OnSaveState(outState);
	}
	public void OnLoadState(Bundle savedInstanceState){
		_cameraService.OnLoadState(savedInstanceState);
	}
	public Camera getCamera(){
		return _cameraService.getCamera();
	}
	public void sensorInit(SensorManager sensorManager){
		_sensorService.init(sensorManager);
		_sensorService.start();
	}
}
