package com.hide.ServiceTest;

import android.app.IntentService;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;

// 非同期のサービス
public class MyService2 extends IntentService  {

	  final static String TAG = "MyService2";

	// NotificationManagerのインスタンスを取得する。コンストラクタはなし。
		private NotificationManager nm;

	public MyService2() {
		super("MyService2");
	}


	protected void onHandleIntent(Intent intent) {
	    Log.d(TAG, "onHandleIntent");

	    nm = (NotificationManager)getSystemService(NOTIFICATION_SERVICE);
		// Notificationのインスタンスを生成する。
	    Notification n;
		// 表示させるアイコンのリソースID、
		// ステータスバーにアイコンが表示される直前にちょっとだけ表示されるテキスト、
		// ステータスバーを引っ張ったときに表示させる時刻を指定する。
	    n = new Notification(R.drawable.icon, "通知情報が届きました(非同期)", System.currentTimeMillis());

		// 「通知」ではなく「実行中」として表示する
		// n.flags = Notification.FLAG_ONGOING_EVENT;
		// Notification表示時に振動
		// n.defaults |= Notification.DEFAULT_VIBRATE;
		// Notification表示時に音を鳴らす
		// n.sound = Uri.parse(ringtoneStr);

		// Notificationをタップしたときに起動するアクティビティを指定するIntentを生成し、PendingIntentに放り込む。
		// Intent i = new Intent(this, com.example.hogehoge.Hogehoge.class);
		Intent i = new Intent(android.content.Intent.ACTION_VIEW, Uri.parse("http://www.google.co.jp"));
		PendingIntent pi;
		pi = PendingIntent.getActivity(this, 0, i, Intent.FLAG_ACTIVITY_NEW_TASK);

		// NotificationのインスタンスにsetLatestEventInfoメソッドを使ってセットする。
		// このとき、ステータスバーを引っ張ったときにNotificationの中で表示されるタイトルとテキストを指定する。
		n.setLatestEventInfo(this, "サービス開始(非同期)", "タイマーを開始しました", pi);

		// NotificationのIDを指定してnotifyする。
		// IDはintなら何でもいい
		// nm.notify(nId, n);
		nm.notify(3, n);

		try {
			// 10秒間停止
			Thread.sleep(10000);
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}

	    Notification n2;
	    n2 = new Notification(R.drawable.icon, "タイマー通知だよ(非同期)", System.currentTimeMillis());
		n2.setLatestEventInfo(this, "タイマー通知(非同期)", "指定時間たったよ", pi);
		// NotificationのIDを指定してnotifyする。
		// IDはintなら何でもいい
		nm.notify(4, n2);

	  }

	  @Override
	  public void onDestroy() {
	    super.onDestroy();
	    Log.d(TAG, "onDestroy");
	  }
}
