#!/usr/bin/perl -w
# This code is a part of Slash, and is released under the GPL.
# Copyright 1997-2005 by Open Source Technology Group. See README
# and COPYING for more information, or see http://slashcode.com/.
# $Id: flush_formkeys.pl,v 1.6 2005/03/11 19:58:47 pudge Exp $

use strict;
use Slash;
use Slash::Constants ':slashd';

my $me = 'flush_formkeys.pl';

use vars qw( %task );

$task{$me}{timespec} = '3 * * * *';
$task{$me}{timespec_panic_1} = ''; # this can wait, hopefully not wait too long
$task{$me}{fork} = SLASHD_NOWAIT;
$task{$me}{code} = sub {
	my($virtual_user, $constants, $slashdb, $user) = @_;

	$slashdb->deleteOldFormkeys($constants->{formkey_timeframe});
};

1;
