INSERT IGNORE INTO vars (name, value, description) VALUES ('dilemma', '1', 'Enable dilemma?');
INSERT IGNORE INTO vars (name, value, description) VALUES ('dilemma_cpu_percent_target', '50', 'What target percentage of the CPU to use while running a tournament');
INSERT IGNORE INTO vars (name, value, description) VALUES ('dilemma_draw_graph_ticks', '100', 'Draw graph every this many ticks (roughly -- before this tickcount, draw every time; after 20x this tickcount, draw 1/3 as often');
INSERT IGNORE INTO vars (name, value, description) VALUES ('dilemma_logdatadump', '0', 'Dump gzipped log data to disk every so often? This can be processor/disk/time intensive');
INSERT IGNORE INTO vars (name, value, description) VALUES ('dilemma_errorchange_id', '0.01', 'Fractional chance of an agent not getting told its opponent\'s ID correctly');
INSERT IGNORE INTO vars (name, value, description) VALUES ('dilemma_errorchange_play', '0.03', 'Fractional amount up to which opponent\'s play can get reported incorrectly');

DELETE FROM dilemma_stats WHERE 1=1;

DELETE FROM dilemma_stat_names WHERE 1=1;
INSERT INTO dilemma_stat_names (dstnmid, name) VALUES (1, 'num_alive');
INSERT INTO dilemma_stat_names (dstnmid, name) VALUES (2, 'sumfood');

DELETE FROM dilemma_species WHERE 1=1;
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES ( 1, 'alld',		667, 'sub play { return 0.0 }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES ( 2, 'd20',		667, 'sub play { return 0.2 }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES ( 3, 'd40',		667, 'sub play { return 0.4 }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES ( 4, 'c60',		667, 'sub play { return 0.6 }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES ( 5, 'c80',		667, 'sub play { return 0.8 }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES ( 6, 'allc',		667, 'sub play { return 1 }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES ( 7, 'random',	667, 'sub play { return rand() }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES ( 8, 'tft',		667, 'sub debrief { $memory->{$it_id} = $it_play } sub play { return exists($memory->{$it_id}) ? $memory->{$it_id} : 1 }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES ( 9, 'randomfixed',	667, 'sub debrief { $memory ||= rand() } sub play { return $memory ||= rand() }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES (10, 'tft_ra',	667, 'sub debrief { $memory->{$it_id} = $it_play } sub play { return exists($memory->{$it_id}) ? $memory->{$it_id} : rand() }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES (11, 'tft_sq',	667, 'sub debrief { $memory->{$it_id} = $it_play } sub play { return exists($memory->{$it_id}) ? $memory->{$it_id} ** 2.0 : 1 }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES (12, 'tft_sqrt',	667, 'sub debrief { $memory->{$it_id} = $it_play } sub play { return exists($memory->{$it_id}) ? $memory->{$it_id} ** 0.5 : 1 }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES (13, 'grudge',	667, 'sub debrief { $memory->{$it_id} = $it_play if !exists($memory->{$it_id}) || $it_play < $memory->{$it_id} } sub play { return exists($memory->{$it_id}) ? $memory->{$it_id} : 1 }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES (14, 'grudge_sq',	667, 'sub debrief { $memory->{$it_id} = $it_play if !exists($memory->{$it_id}) || $it_play < $memory->{$it_id} } sub play { return exists($memory->{$it_id}) ? $memory->{$it_id} ** 2.0 : 1 }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES (15, 'tft_zg',	667, 'sub debrief { $memory->{$it_id} = $it_play; my $zg = $memory->{zg}; push @$zg, $it_play; shift @$zg if @$zg > 10; } sub zeitgeist { my $zg = $memory->{zg}; return 1 unless $zg && @$zg; my $sum = 0; for (@$zg) { $sum += $_ } return $sum / @$zg; } sub play { return exists($memory->{$it_id}) ? $memory->{$it_id} : zeitgeist() }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES (16, 'tft_zgns',	667, 'sub debrief { $memory->{$it_id} = $it_play; my $zg = $memory->{zg}; push @$zg, $it_play; shift @$zg if @$zg > 10; } sub zeitgeist { my $zg = $memory->{zg}; return 1 unless $zg && @$zg; my $sum = 0; for (@$zg) { $sum += $_ } return $sum / @$zg; } sub noisify { my($n) = @_; $n += rand(1) * 0.1 - 0.05; $n = 0 if $n < 0; $n = 1 if $n > 1; } sub play { return exists($memory->{$it_id}) ? noisify($memory->{$it_id}) : noisify(zeitgeist()) }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES (17, 'tft_zgnsfs',	667, 'sub debrief { $memory->{$it_id} = $it_play; my $zg = $memory->{zg}; push @$zg, $it_play; shift @$zg if @$zg > 10; $memory->{minfs} = $foodsize if !exists($memory->{minfs}) || $foodsize < $memory->{minfs}; $memory->{maxfs} = $foodsize if $foodsize > $memory->{maxfs}; } sub zeitgeist { my $zg = $memory->{zg}; return 1 unless $zg && @$zg; my $sum = 0; for (@$zg) { $sum += $_ } return $sum / @$zg; } sub foodgreedfactor { return 0 unless $memory->{maxfs}; if ($foodsize < $memory->{minfs} * 1.25) { return 0.1 } elsif ($foodsize > $memory->{maxfs} * 0.8) { return -0.1 } else { return 0 } } sub noisify { my($n) = @_; $n += rand(1) * 0.1 - 0.05; $n = 0 if $n < 0; $n = 1 if $n > 1; } sub play { return exists($memory->{$it_id}) ? noisify($memory->{$it_id} + foodgreedfactor()) : noisify(zeitgeist() + foodgreedfactor()) }');
INSERT INTO dilemma_species (dsid, name, uid, code) VALUES (18, 'wslc',		667, 'sub abs { $_[0] < 0 ? -$_[0] : $_[0] } sub debrief { $memory->{$it_id} = 1 - &abs($me_play-$it_play) } sub play { return exists($memory->{$it_id}) ? $memory->{$it_id} : 1 }');

DELETE FROM dilemma_agents WHERE 1=1;
INSERT INTO dilemma_agents (dsid, food) VALUES (1, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (1, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (1, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (1, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (1, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (1, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (2, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (2, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (2, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (2, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (2, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (2, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (3, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (3, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (3, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (3, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (3, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (3, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (4, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (4, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (4, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (4, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (4, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (4, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (5, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (5, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (5, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (5, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (5, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (5, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (6, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (6, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (6, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (6, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (6, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (6, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (7, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (7, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (7, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (7, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (7, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (7, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (8, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (8, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (8, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (8, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (8, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (8, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (9, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (9, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (9, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (9, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (9, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (9, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (10, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (10, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (10, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (10, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (10, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (10, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (11, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (11, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (11, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (11, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (11, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (11, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (12, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (12, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (12, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (12, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (12, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (12, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (13, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (13, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (13, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (13, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (13, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (13, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (14, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (14, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (14, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (14, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (14, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (14, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (15, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (15, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (15, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (15, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (15, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (15, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (16, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (16, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (16, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (16, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (16, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (16, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (17, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (17, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (17, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (17, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (17, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (17, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (18, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (18, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (18, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (18, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (18, 5);
INSERT INTO dilemma_agents (dsid, food) VALUES (18, 5);
UPDATE dilemma_agents SET trid=1;

DELETE FROM dilemma_tournament_info WHERE 1=1;

INSERT INTO dilemma_tournament_info (trid, active, max_tick, last_tick, food_per_tick, birth_food, idle_food, min_meets, max_meets, graph_drawn_tick) VALUES (1, 'yes', 1000, 0, 1, 10, 0.05, 10, 30, 0);

