/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.control.AckCommand;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.clustering.control.GetConfigurationCommand;
import org.apache.axis2.clustering.control.GetConfigurationResponseCommand;
import org.apache.axis2.clustering.control.GetStateCommand;
import org.apache.axis2.clustering.control.GetStateResponseCommand;
import org.apache.axis2.clustering.tribes.ChannelSender;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.tribes.Member;

public class TribesControlCommandProcessor {
    private ConfigurationContext configurationContext;
    private ChannelSender channelSender;

    public void setChannelSender(ChannelSender channelSender) {
        this.channelSender = channelSender;
    }

    public TribesControlCommandProcessor(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void process(ControlCommand command, Member sender) throws ClusteringFault {
        if (command instanceof GetStateCommand) {
            if (this.configurationContext.getPropertyNonReplicable("local_cluster.initialized") == null) {
                return;
            }
            command.execute(this.configurationContext);
            GetStateResponseCommand getStateRespCmd = new GetStateResponseCommand();
            getStateRespCmd.setCommands(((GetStateCommand)command).getCommands());
            this.channelSender.sendToMember(getStateRespCmd, sender);
        } else if (command instanceof GetConfigurationCommand) {
            if (this.configurationContext.getPropertyNonReplicable("local_cluster.initialized") == null) {
                return;
            }
            command.execute(this.configurationContext);
            GetConfigurationResponseCommand getConfigRespCmd = new GetConfigurationResponseCommand();
            getConfigRespCmd.setServiceGroups(((GetConfigurationCommand)command).getServiceGroupNames());
            this.channelSender.sendToMember(getConfigRespCmd, sender);
        } else if (command instanceof AckCommand) {
            AckCommand cmd = (AckCommand)command;
            cmd.setMemberId(TribesUtil.getHost(sender));
            cmd.execute(this.configurationContext);
        } else {
            command.execute(this.configurationContext);
        }
    }
}

