/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxbri;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.util.SchemaUtil;
import org.apache.axis2.util.URLProcessor;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.databinding.DefaultTypeMapper;
import org.apache.axis2.wsdl.databinding.JavaTypeMapper;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CodeGenerationUtility {
    private static final Log log = LogFactory.getLog(CodeGenerationUtility.class);

    public static TypeMapper processSchemas(final List schemas, Element[] additionalSchemas, CodeGenConfiguration cgconfig) throws RuntimeException {
        try {
            if (schemas == null || schemas.isEmpty()) {
                return new DefaultTypeMapper();
            }
            ArrayList<InputSource> xmlObjectsVector = new ArrayList<InputSource>();
            JavaTypeMapper mapper = new JavaTypeMapper();
            final String baseURI = cgconfig.getBaseURI();
            for (int i = 0; i < schemas.size(); ++i) {
                XmlSchema schema = (XmlSchema)schemas.get(i);
                InputSource inputSource = new InputSource(new StringReader(CodeGenerationUtility.getSchemaAsString(schema)));
                inputSource.setSystemId(baseURI);
                xmlObjectsVector.add(inputSource);
            }
            File outputDir = new File(cgconfig.getOutputLocation(), "src");
            outputDir.mkdir();
            Map nsMap = cgconfig.getUri2PackageNameMap();
            EntityResolver resolver = new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    for (int i = 0; i < schemas.size(); ++i) {
                        XmlSchema schema = (XmlSchema)schemas.get(i);
                        if (!schema.getTargetNamespace().equals(publicId)) continue;
                        InputSource inputSource = new InputSource(new StringReader(CodeGenerationUtility.getSchemaAsString(schema)));
                        inputSource.setSystemId(baseURI);
                        return inputSource;
                    }
                    return null;
                }
            };
            for (int i = 0; i < xmlObjectsVector.size(); ++i) {
                SchemaCompiler sc = XJC.createSchemaCompiler();
                XmlSchema schema = (XmlSchema)schemas.get(i);
                if (nsMap != null) {
                    for (Map.Entry entry : nsMap.entrySet()) {
                        String namespace = (String)entry.getKey();
                        String pkg = (String)nsMap.get(namespace);
                        CodeGenerationUtility.registerNamespace(sc, namespace, pkg);
                    }
                } else {
                    String namespace = schema.getTargetNamespace();
                    String pkg = CodeGenerationUtility.extractNamespace(schema);
                    CodeGenerationUtility.registerNamespace(sc, namespace, pkg);
                }
                sc.setEntityResolver(resolver);
                sc.setErrorListener(new ErrorListener(){

                    public void error(SAXParseException saxParseException) {
                        log.error((Object)saxParseException.getMessage());
                        log.debug((Object)saxParseException.getMessage(), (Throwable)saxParseException);
                    }

                    public void fatalError(SAXParseException saxParseException) {
                        log.error((Object)saxParseException.getMessage());
                        log.debug((Object)saxParseException.getMessage(), (Throwable)saxParseException);
                    }

                    public void warning(SAXParseException saxParseException) {
                        log.warn((Object)saxParseException.getMessage());
                        log.debug((Object)saxParseException.getMessage(), (Throwable)saxParseException);
                    }

                    public void info(SAXParseException saxParseException) {
                        log.info((Object)saxParseException.getMessage());
                        log.debug((Object)saxParseException.getMessage(), (Throwable)saxParseException);
                    }
                });
                sc.parseSchema((InputSource)xmlObjectsVector.get(i));
                S2JJAXBModel jaxbModel = sc.bind();
                if (jaxbModel == null) {
                    throw new RuntimeException("Unable to generate code using jaxbri");
                }
                JCodeModel codeModel = jaxbModel.generateCode(null, null);
                FileCodeWriter writer = new FileCodeWriter(outputDir);
                codeModel.build((CodeWriter)writer);
                Collection mappings = jaxbModel.getMappings();
                for (Mapping mapping : mappings) {
                    QName qn = mapping.getElement();
                    String typeName = mapping.getType().getTypeClass().fullName();
                    mapper.addTypeMappingName(qn, typeName);
                }
            }
            return mapper;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void registerNamespace(SchemaCompiler sc, String namespace, String pkgName) throws Exception {
        Document doc = XMLUtils.newDocument();
        Element rootElement = doc.createElement("schema");
        rootElement.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
        rootElement.setAttribute("xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
        rootElement.setAttribute("jaxb:version", "2.0");
        rootElement.setAttribute("targetNamespace", namespace);
        Element annoElement = doc.createElement("annotation");
        Element appInfo = doc.createElement("appinfo");
        Element schemaBindings = doc.createElement("jaxb:schemaBindings");
        Element pkgElement = doc.createElement("jaxb:package");
        pkgElement.setAttribute("name", pkgName);
        annoElement.appendChild(appInfo);
        appInfo.appendChild(schemaBindings);
        schemaBindings.appendChild(pkgElement);
        rootElement.appendChild(annoElement);
        File file = File.createTempFile("customized", ".xsd");
        FileOutputStream stream = new FileOutputStream(file);
        try {
            StreamResult result = new StreamResult(stream);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(new DOMSource(rootElement), result);
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputSource ins = new InputSource(file.toURI().toString());
        sc.parseSchema(ins);
        file.delete();
    }

    private static String extractNamespace(XmlSchema schema) {
        String pkg = schema.getTargetNamespace();
        if (pkg == null) {
            XmlSchema[] schemas2 = SchemaUtil.getAllSchemas((XmlSchema)schema);
            for (int j = 0; schemas2 != null && j < schemas2.length && (pkg = schemas2[j].getTargetNamespace()) == null; ++j) {
            }
        }
        if (pkg == null) {
            pkg = "org.apache.axis2";
        }
        pkg = URLProcessor.makePackageName((String)pkg);
        return pkg;
    }

    private static String getSchemaAsString(XmlSchema schema) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        schema.write((OutputStream)baos);
        return baos.toString();
    }
}

