/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.params;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.HttpLinkedParams;
import org.apache.http.params.HttpParams;

public class BasicHttpParams
extends AbstractHttpParams
implements HttpLinkedParams,
Serializable {
    static final long serialVersionUID = 4571099216197814749L;
    protected HttpParams defaults;
    private HashMap parameters;

    public BasicHttpParams(HttpParams defaults) {
        this.setDefaults(defaults);
    }

    public BasicHttpParams() {
        this(null);
    }

    public HttpParams getDefaults() {
        return this.defaults;
    }

    public void setDefaults(HttpParams params) {
        this.defaults = params;
    }

    public Object getParameter(String name) {
        Object param = null;
        if (this.parameters != null) {
            param = this.parameters.get(name);
        }
        if (param != null) {
            return param;
        }
        if (this.defaults != null) {
            return this.defaults.getParameter(name);
        }
        return null;
    }

    public HttpParams setParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(name, value);
        return this;
    }

    public void setParameters(String[] names, Object value) {
        for (int i = 0; i < names.length; ++i) {
            this.setParameter(names[i], value);
        }
    }

    public boolean isParameterSet(String name) {
        return this.getParameter(name) != null;
    }

    public boolean isParameterSetLocally(String name) {
        return this.parameters != null && this.parameters.get(name) != null;
    }

    public void clear() {
        this.parameters = null;
    }

    public HttpParams copy() {
        BasicHttpParams bhp = new BasicHttpParams(this.defaults);
        this.copyParams(bhp);
        return bhp;
    }

    protected void copyParams(HttpParams target) {
        if (this.parameters == null) {
            return;
        }
        Iterator iter = this.parameters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            if (!(me.getKey() instanceof String)) continue;
            target.setParameter((String)me.getKey(), me.getValue());
        }
    }
}

