/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.ProtocolException;
import org.apache.http.io.HttpDataReceiver;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;

public final class HeaderUtils {
    private HeaderUtils() {
    }

    public static Header[] parseHeaders(HttpDataReceiver datareceiver, int maxHeaderCount, int maxLineLen) throws HttpException, IOException {
        int i;
        ArrayList<CharArrayBuffer> headerLines;
        block10: {
            if (datareceiver == null) {
                throw new IllegalArgumentException("HTTP data receiver may not be null");
            }
            headerLines = new ArrayList<CharArrayBuffer>();
            CharArrayBuffer current = null;
            CharArrayBuffer previous = null;
            do {
                if (current == null) {
                    current = new CharArrayBuffer(64);
                } else {
                    current.clear();
                }
                int l = datareceiver.readLine(current);
                if (l == -1 || current.length() < 1) break block10;
                if ((current.charAt(0) == ' ' || current.charAt(0) == '\t') && previous != null) {
                    char ch;
                    for (i = 0; i < current.length() && ((ch = current.charAt(i)) == ' ' || ch == '\t'); ++i) {
                    }
                    if (maxLineLen > 0 && previous.length() + 1 + current.length() - i > maxLineLen) {
                        throw new IOException("Maximum line length limit exceeded");
                    }
                    previous.append(' ');
                    previous.append(current, i, current.length() - i);
                    continue;
                }
                headerLines.add(current);
                previous = current;
                current = null;
            } while (maxHeaderCount <= 0 || headerLines.size() < maxHeaderCount);
            throw new IOException("Maximum header count exceeded");
        }
        Header[] headers = new Header[headerLines.size()];
        for (i = 0; i < headerLines.size(); ++i) {
            CharArrayBuffer buffer = (CharArrayBuffer)headerLines.get(i);
            try {
                headers[i] = new BufferedHeader(buffer);
                continue;
            }
            catch (IllegalArgumentException ex) {
                throw new ProtocolException(ex.getMessage());
            }
        }
        return headers;
    }

    public static Header[] parseHeaders(HttpDataReceiver datareceiver) throws HttpException, IOException {
        return HeaderUtils.parseHeaders(datareceiver, -1, -1);
    }
}

