/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.NumberComboBoxPanel;
import de.hunsicker.jalopy.swing.NumberComboBoxPanelCheckBox;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.swing.EmptyButtonGroup;
import de.hunsicker.swing.util.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WrappingSettingsPage
extends AbstractSettingsPage {
    private JCheckBox _alignExpressionCheckBox;
    private JCheckBox _alignMethodCallParamsCheckBox;
    private JCheckBox _alignMethodCallParamsIfNestedCheckBox;
    private JCheckBox _alignParamsCheckBox;
    private JCheckBox _alignValuesCheckBox;
    private JCheckBox _wrapAfterAssignCheckBox;
    private JCheckBox _wrapAfterChainedCallCheckBox;
    private JCheckBox _wrapAfterCheckBox;
    private JCheckBox _wrapParamsHardCheckBox;
    private JCheckBox _wrapParamsDeepCheckBox;
    private JCheckBox _wrapAfterExtendsCheckBox;
    private JCheckBox _wrapAfterImplementsCheckBox;
    private JCheckBox _wrapAfterLeftParenCheckBox;
    private JCheckBox _wrapAfterThrowsTypesCheckBox;
    private JCheckBox _wrapAllExtendsTypesExceedCheckBox;
    private JCheckBox _wrapAllImplementsTypesExceedCheckBox;
    private JCheckBox _wrapAllParamIfFirstCheckBox;
    private JCheckBox _wrapAllThrowsTypesIfExceedCheckBox;
    private JCheckBox _wrapBeforeCheckBox;
    private JCheckBox _wrapBeforeExtendsCheckBox;
    private JCheckBox _wrapBeforeImplementsCheckBox;
    private JCheckBox _wrapBeforeRightParenCheckBox;
    private JCheckBox _wrapBeforeThrowsCheckBox;
    private JCheckBox _wrapGroupingParenCheckBox;
    private JCheckBox _wrapLabelsCheckBox;
    private JCheckBox _wrapLinesCheckBox;
    private JComboBox _indentDeepComboBox;
    private JComboBox _lineLengthComboBox;
    private JTabbedPane _tabbedPane;
    ComboPanel enumPanel = null;
    ComboPanel arraysPanel = null;
    ComboPanel annotationDefPanel = null;
    ComboPanel annotationPanel = null;

    public WrappingSettingsPage() {
        this.initialize();
    }

    WrappingSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public String getPreviewFileName() {
        switch (this._tabbedPane.getSelectedIndex()) {
            case 1: {
                return "wrappingmisc";
            }
        }
        return super.getPreviewFileName();
    }

    public void updateSettings() {
        this.settings.putBoolean(ConventionKeys.LINE_WRAP, this._wrapLinesCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_BEFORE_OPERATOR, this._wrapBeforeCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_LABEL, this._wrapLabelsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_PAREN_GROUPING, this._wrapGroupingParenCheckBox.isSelected());
        this.settings.put(ConventionKeys.LINE_LENGTH, (String)this._lineLengthComboBox.getSelectedItem());
        this.settings.putBoolean(ConventionKeys.ALIGN_TERNARY_EXPRESSION, this._alignExpressionCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.ALIGN_TERNARY_VALUES, this._alignValuesCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_BEFORE_THROWS, this._wrapBeforeThrowsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS, this._wrapAfterThrowsTypesCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_IMPLEMENTS, this._wrapAfterImplementsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_EXTENDS, this._wrapAfterExtendsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_CALL, this._alignMethodCallParamsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_ASSIGN, this._wrapAfterAssignCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, this._wrapAllParamIfFirstCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN, this._wrapAfterLeftParenCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_BEFORE_RIGHT_PAREN, this._wrapBeforeRightParenCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_CALL_IF_NESTED, this._alignMethodCallParamsIfNestedCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_DEF, this._alignParamsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_BEFORE_EXTENDS, this._wrapBeforeExtendsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_BEFORE_IMPLEMENTS, this._wrapBeforeImplementsCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_CHAINED_METHOD_CALL, this._wrapAfterChainedCallCheckBox.isSelected());
        this.settings.put(ConventionKeys.INDENT_SIZE_DEEP, (String)this._indentDeepComboBox.getSelectedItem());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_EXTENDS_EXCEED, this._wrapAllExtendsTypesExceedCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_IMPLEMENTS_EXCEED, this._wrapAllImplementsTypesExceedCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS_EXCEED, this._wrapAllThrowsTypesIfExceedCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_PARAMS_HARD, this._wrapParamsHardCheckBox.isSelected());
        this.settings.putBoolean(ConventionKeys.LINE_WRAP_PARAMS_DEEP, this._wrapParamsDeepCheckBox.isSelected());
        this.arraysPanel.setSettings(ConventionKeys.LINE_WRAP_ARRAY_ELEMENTS, ConventionKeys.LINE_WRAP_ARRAY_ELEMENTS);
        this.enumPanel.setSettings(ConventionKeys.ENUM_LCURLY_NO_NEW_LINE, ConventionKeys.ENUM_ALIGN_VALUES_WHEN_EXCEEDS);
        this.annotationPanel.setSettings(ConventionKeys.ANON_LCURLY_NO_NEW_LINE, ConventionKeys.ANON_ALIGN_VALUES_WHEN_EXCEEDS);
        this.annotationDefPanel.setSettings(ConventionKeys.ANON_DEF_LCURLY_NO_NEW_LINE, ConventionKeys.ANON_DEF_ALIGN_VALUES_WHEN_EXCEEDS);
    }

    private JPanel createAlwaysPane() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel wrapAlwaysPanel = new JPanel();
        GridBagLayout wrapAlwaysPanelLayout = new GridBagLayout();
        wrapAlwaysPanel.setLayout(wrapAlwaysPanelLayout);
        wrapAlwaysPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_WRAP_ALWAYS")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this._wrapBeforeExtendsCheckBox = new JCheckBox(this.bundle.getString("CHK_BEFORE_EXTENDS_KEYWORD"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_EXTENDS, false));
        this._wrapBeforeExtendsCheckBox.addActionListener(this.trigger);
        c.insets.left = 0;
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._wrapBeforeExtendsCheckBox, c);
        wrapAlwaysPanel.add(this._wrapBeforeExtendsCheckBox);
        this._wrapAfterExtendsCheckBox = new JCheckBox(this.bundle.getString("CHK_AFTER_EXTENDS_TYPES"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_EXTENDS, false));
        this._wrapAfterExtendsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._wrapAfterExtendsCheckBox, c);
        wrapAlwaysPanel.add(this._wrapAfterExtendsCheckBox);
        this._wrapBeforeImplementsCheckBox = new JCheckBox(this.bundle.getString("CHK_BEFORE_IMPLEMENTS_KEYWORD"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_IMPLEMENTS, false));
        this._wrapBeforeImplementsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._wrapBeforeImplementsCheckBox, c);
        wrapAlwaysPanel.add(this._wrapBeforeImplementsCheckBox);
        this._wrapAfterImplementsCheckBox = new JCheckBox(this.bundle.getString("CHK_AFTER_IMPLEMENTS_TYPES"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_IMPLEMENTS, false));
        this._wrapAfterImplementsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 1, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._wrapAfterImplementsCheckBox, c);
        wrapAlwaysPanel.add(this._wrapAfterImplementsCheckBox);
        this._wrapBeforeThrowsCheckBox = new JCheckBox(this.bundle.getString("CHK_BEFORE_THROWS_KEYWORD"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_THROWS, false));
        this._wrapBeforeThrowsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 2, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._wrapBeforeThrowsCheckBox, c);
        wrapAlwaysPanel.add(this._wrapBeforeThrowsCheckBox);
        this._wrapAfterThrowsTypesCheckBox = new JCheckBox(this.bundle.getString("CHK_AFTER_THROWS_TYPES"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS, false));
        this._wrapAfterThrowsTypesCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 2, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._wrapAfterThrowsTypesCheckBox, c);
        wrapAlwaysPanel.add(this._wrapAfterThrowsTypesCheckBox);
        this._alignParamsCheckBox = new JCheckBox(this.bundle.getString("CHK_METHOD_PARAM"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_DEF, false));
        this._alignParamsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 3, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._alignParamsCheckBox, c);
        wrapAlwaysPanel.add(this._alignParamsCheckBox);
        this._wrapAfterChainedCallCheckBox = new JCheckBox(this.bundle.getString("CHK_METHOD_CALL_CHAINED"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_CHAINED_METHOD_CALL, false));
        this._wrapAfterChainedCallCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 3, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._wrapAfterChainedCallCheckBox, c);
        wrapAlwaysPanel.add(this._wrapAfterChainedCallCheckBox);
        this._alignMethodCallParamsCheckBox = new JCheckBox(this.bundle.getString("CHK_METHOD_CALL_PARAM"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_CALL, false));
        this._alignMethodCallParamsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 4, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._alignMethodCallParamsCheckBox, c);
        wrapAlwaysPanel.add(this._alignMethodCallParamsCheckBox);
        this._alignMethodCallParamsIfNestedCheckBox = new JCheckBox(this.bundle.getString("CHK_METHOD_CALL_PARAM_NESTED"), !this._alignMethodCallParamsCheckBox.isSelected() && this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_CALL_IF_NESTED, false));
        this._alignMethodCallParamsIfNestedCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 4, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._alignMethodCallParamsIfNestedCheckBox, c);
        wrapAlwaysPanel.add(this._alignMethodCallParamsIfNestedCheckBox);
        EmptyButtonGroup group = new EmptyButtonGroup();
        group.add(this._alignMethodCallParamsCheckBox);
        group.add(this._alignMethodCallParamsIfNestedCheckBox);
        this._alignExpressionCheckBox = new JCheckBox(this.bundle.getString("CHK_TERNARY_EXPRESSION_QUESTIONMARK"), this.settings.getBoolean(ConventionKeys.ALIGN_TERNARY_EXPRESSION, false));
        this._alignExpressionCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 5, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._alignExpressionCheckBox, c);
        wrapAlwaysPanel.add(this._alignExpressionCheckBox);
        this._alignValuesCheckBox = new JCheckBox(this.bundle.getString("CHK_TERNARY_EXPRESSION_COLON"), this.settings.getBoolean(ConventionKeys.ALIGN_TERNARY_VALUES, false));
        this._alignValuesCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 5, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._alignValuesCheckBox, c);
        wrapAlwaysPanel.add(this._alignValuesCheckBox);
        this._wrapLabelsCheckBox = new JCheckBox(this.bundle.getString("CHK_LABELS"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LABEL, true));
        this._wrapLabelsCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 6, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        wrapAlwaysPanelLayout.setConstraints(this._wrapLabelsCheckBox, c);
        wrapAlwaysPanel.add(this._wrapLabelsCheckBox);
        JPanel wrapAllPanel = new JPanel();
        GridBagLayout wrapAllPanelLayout = new GridBagLayout();
        wrapAllPanel.setLayout(wrapAllPanelLayout);
        wrapAllPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_WRAP_ALL")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this._wrapAllExtendsTypesExceedCheckBox = new JCheckBox(this.bundle.getString("CHK_WRAP_ALL_EXTENDS_TYPES_IF_FIRST"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_EXTENDS_EXCEED, false));
        this._wrapAllExtendsTypesExceedCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapAllPanelLayout.setConstraints(this._wrapAllExtendsTypesExceedCheckBox, c);
        wrapAllPanel.add(this._wrapAllExtendsTypesExceedCheckBox);
        this._wrapAllImplementsTypesExceedCheckBox = new JCheckBox(this.bundle.getString("CHK_WRAP_ALL_IMPLEMENTS_TYPES_IF_FIRST"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_IMPLEMENTS_EXCEED, false));
        this._wrapAllImplementsTypesExceedCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapAllPanelLayout.setConstraints(this._wrapAllImplementsTypesExceedCheckBox, c);
        wrapAllPanel.add(this._wrapAllImplementsTypesExceedCheckBox);
        this._wrapAllThrowsTypesIfExceedCheckBox = new JCheckBox(this.bundle.getString("CHK_WRAP_ALL_THROWS_TYPES_IF_FIRST"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS_EXCEED, false));
        this._wrapAllThrowsTypesIfExceedCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        wrapAllPanelLayout.setConstraints(this._wrapAllThrowsTypesIfExceedCheckBox, c);
        wrapAllPanel.add(this._wrapAllThrowsTypesIfExceedCheckBox);
        this._wrapAllParamIfFirstCheckBox = new JCheckBox(this.bundle.getString("CHK_WRAP_ALL_PARAM_IF_FIRST"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false));
        this._wrapAllParamIfFirstCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 1, 0, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        wrapAllPanelLayout.setConstraints(this._wrapAllParamIfFirstCheckBox, c);
        wrapAllPanel.add(this._wrapAllParamIfFirstCheckBox);
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        c.insets.bottom = 10;
        c.insets.top = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
        layout.setConstraints(wrapAlwaysPanel, c);
        panel.add(wrapAlwaysPanel);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 2, c.insets, 5, 5);
        layout.setConstraints(wrapAllPanel, c);
        panel.add(wrapAllPanel);
        return panel;
    }

    private JPanel createGeneralPane() {
        JPanel generalPanel = new JPanel();
        GridBagLayout generalPanelLayout = new GridBagLayout();
        generalPanel.setLayout(generalPanelLayout);
        generalPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_GENERAL")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints c = new GridBagConstraints();
        this._wrapLinesCheckBox = new JCheckBox(this.bundle.getString("CHK_WRAP_LINES"), this.settings.getBoolean(ConventionKeys.LINE_WRAP, true));
        this._wrapLinesCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 0.0, 17, 2, c.insets, 10, 0);
        generalPanelLayout.setConstraints(this._wrapLinesCheckBox, c);
        generalPanel.add(this._wrapLinesCheckBox);
        Object[] lengths = this.createItemList(new int[]{70, 79, 80, 90, 100});
        NumberComboBoxPanel lineLengthComboBoxPanel = new NumberComboBoxPanel(this.bundle.getString("CMB_LINE_LENGTH"), lengths, this.settings.get(ConventionKeys.LINE_LENGTH, String.valueOf(80)));
        this._lineLengthComboBox = lineLengthComboBoxPanel.getComboBox();
        this._lineLengthComboBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 0, 1, 1, 1.0, 0.0, 13, 0, c.insets, 0, 0);
        generalPanelLayout.setConstraints(lineLengthComboBoxPanel, c);
        generalPanel.add(lineLengthComboBoxPanel);
        Object[] deepIndentSizeItems = this.createItemList(new int[]{50, 55, 60, 65, 70, 75});
        NumberComboBoxPanel deepIndent = new NumberComboBoxPanel(this.bundle.getString("CMB_DEEP_INDENT"), deepIndentSizeItems, this.settings.get(ConventionKeys.INDENT_SIZE_DEEP, String.valueOf(55)));
        this._indentDeepComboBox = deepIndent.getComboBox();
        this._indentDeepComboBox.addActionListener(this.trigger);
        c.insets.left = 10;
        SwingHelper.setConstraints(c, 2, 0, 0, 1, 1.0, 0.0, 13, 0, c.insets, 0, 0);
        generalPanelLayout.setConstraints(deepIndent, c);
        generalPanel.add(deepIndent);
        c.insets.left = 0;
        JPanel wrapPolicyPanel = new JPanel();
        GridBagLayout wrapPolicyPanelLayout = new GridBagLayout();
        wrapPolicyPanel.setLayout(wrapPolicyPanelLayout);
        wrapPolicyPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("BDR_WRAP_POLICY")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this._wrapAfterLeftParenCheckBox = new JCheckBox(this.bundle.getString("CHK_WRAP_AFTER_LEFT_PAREN"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN, false));
        this._wrapAfterLeftParenCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapPolicyPanelLayout.setConstraints(this._wrapAfterLeftParenCheckBox, c);
        wrapPolicyPanel.add(this._wrapAfterLeftParenCheckBox);
        this._wrapBeforeRightParenCheckBox = new JCheckBox(this.bundle.getString("CHK_WRAP_BEFORE_RIGHT_PAREN"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_RIGHT_PAREN, false));
        this._wrapBeforeRightParenCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 0, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapPolicyPanelLayout.setConstraints(this._wrapBeforeRightParenCheckBox, c);
        wrapPolicyPanel.add(this._wrapBeforeRightParenCheckBox);
        this._wrapAfterAssignCheckBox = new JCheckBox(this.bundle.getString("CHK_WRAP_AFTER_ASSIGN"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_ASSIGN, false));
        this._wrapAfterAssignCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 1, 1, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapPolicyPanelLayout.setConstraints(this._wrapAfterAssignCheckBox, c);
        wrapPolicyPanel.add(this._wrapAfterAssignCheckBox);
        this._wrapGroupingParenCheckBox = new JCheckBox(this.bundle.getString("CHK_WRAP_GROUPING"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_PAREN_GROUPING, false));
        this._wrapGroupingParenCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 1, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
        wrapPolicyPanelLayout.setConstraints(this._wrapGroupingParenCheckBox, c);
        wrapPolicyPanel.add(this._wrapGroupingParenCheckBox);
        this._wrapBeforeCheckBox = new JCheckBox(this.bundle.getString("CHK_WRAP_BEFORE_OPERATOR"), this.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_OPERATOR, false));
        this._wrapBeforeCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 2, 1, 1, 1.0, 1.0, 17, 2, c.insets, 0, 0);
        wrapPolicyPanelLayout.setConstraints(this._wrapBeforeCheckBox, c);
        wrapPolicyPanel.add(this._wrapBeforeCheckBox);
        this._wrapAfterCheckBox = new JCheckBox(this.bundle.getString("CHK_WRAP_AFTER_OPERATOR"), !this.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_OPERATOR, false));
        this._wrapAfterCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 2, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        wrapPolicyPanelLayout.setConstraints(this._wrapAfterCheckBox, c);
        wrapPolicyPanel.add(this._wrapAfterCheckBox);
        this._wrapParamsHardCheckBox = new JCheckBox("Deep wrap on params", this.settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_HARD, false));
        this._wrapParamsHardCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 0, 3, -1, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        wrapPolicyPanelLayout.setConstraints(this._wrapParamsHardCheckBox, c);
        wrapPolicyPanel.add(this._wrapParamsHardCheckBox);
        this._wrapParamsHardCheckBox.addActionListener(new AbstractAction(""){

            public void actionPerformed(ActionEvent e) {
                WrappingSettingsPage.this._wrapParamsDeepCheckBox.setEnabled(WrappingSettingsPage.this._wrapParamsHardCheckBox.isSelected());
            }
        });
        this._wrapParamsDeepCheckBox = new JCheckBox("When wrap use deep", this.settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_DEEP, false));
        this._wrapParamsDeepCheckBox.addActionListener(this.trigger);
        SwingHelper.setConstraints(c, 1, 3, 0, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
        wrapPolicyPanelLayout.setConstraints(this._wrapParamsDeepCheckBox, c);
        wrapPolicyPanel.add(this._wrapParamsDeepCheckBox);
        ButtonGroup operatorButtonGroup = new ButtonGroup();
        operatorButtonGroup.add(this._wrapBeforeCheckBox);
        operatorButtonGroup.add(this._wrapAfterCheckBox);
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        c.insets.bottom = 10;
        c.insets.top = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 5, 5);
        layout.setConstraints(generalPanel, c);
        panel.add(generalPanel);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 2, c.insets, 5, 5);
        layout.setConstraints(wrapPolicyPanel, c);
        panel.add(wrapPolicyPanel);
        return panel;
    }

    private JPanel createMiscPane() {
        GridBagConstraints c = new GridBagConstraints();
        String[] items = this.createItemList(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        int arrayElements = this.settings.getInt(ConventionKeys.LINE_WRAP_ARRAY_ELEMENTS, 0);
        this.arraysPanel = new ComboPanel(this.bundle.getString("BDR_ARRAYS"), this.bundle.getString("CHK_WRAP_AS_NEEDED"), this.bundle.getString("CHK_WRAP_AFTER_ELEMENT"), this.bundle.getString("CMB_NUMBER"), arrayElements, items, c);
        arrayElements = this.settings.getInt(ConventionKeys.ENUM_ALIGN_VALUES_WHEN_EXCEEDS, 0);
        this.enumPanel = new ComboPanel(this.bundle.getString("LBL_ENUM"), this.bundle.getString("LBL_LEFT_BRACES_NOT_NEW_LINE"), this.bundle.getString("LBL_LEFT_BRACES_NEW_LINE"), this.bundle.getString("CMB_NUMBER"), arrayElements, items, c);
        arrayElements = this.settings.getInt(ConventionKeys.ANON_ALIGN_VALUES_WHEN_EXCEEDS, 0);
        this.annotationPanel = new ComboPanel(this.bundle.getString("LBL_ANON"), this.bundle.getString("LBL_LEFT_BRACES_NOT_NEW_LINE"), this.bundle.getString("LBL_LEFT_BRACES_NEW_LINE"), this.bundle.getString("CMB_NUMBER"), arrayElements, items, c);
        arrayElements = this.settings.getInt(ConventionKeys.ANON_DEF_ALIGN_VALUES_WHEN_EXCEEDS, 0);
        this.annotationDefPanel = new ComboPanel(this.bundle.getString("LBL_ANON_DEF"), this.bundle.getString("LBL_LEFT_BRACES_NOT_NEW_LINE"), this.bundle.getString("LBL_LEFT_BRACES_NEW_LINE"), this.bundle.getString("CMB_NUMBER"), arrayElements, items, c);
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        c.insets.bottom = 10;
        c.insets.top = 10;
        c.insets.left = 5;
        c.insets.right = 5;
        SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 1.0, 18, 2, c.insets, 5, 5);
        layout.setConstraints(this.arraysPanel, c);
        panel.add(this.arraysPanel);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 1.0, 18, 2, c.insets, 5, 5);
        layout.setConstraints(this.enumPanel, c);
        panel.add(this.enumPanel);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 1.0, 18, 2, c.insets, 5, 5);
        layout.setConstraints(this.annotationPanel, c);
        panel.add(this.annotationPanel);
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 0, 3, 0, 1, 1.0, 1.0, 18, 2, c.insets, 5, 5);
        layout.setConstraints(this.annotationDefPanel, c);
        panel.add(this.annotationDefPanel);
        return panel;
    }

    private void initialize() {
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.add((Component)this.createGeneralPane(), this.bundle.getString("TAB_GENERAL"));
        this._tabbedPane.add((Component)this.createAlwaysPane(), this.bundle.getString("TAB_ALWAYS"));
        this._tabbedPane.add((Component)this.createMiscPane(), this.bundle.getString("TAB_MISC"));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add((Component)this._tabbedPane, "Center");
        if (this.getContainer() != null) {
            this._tabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    String text = WrappingSettingsPage.this.getContainer().loadPreview(WrappingSettingsPage.this.getPreviewFileName());
                    WrappingSettingsPage.this.getContainer().getPreview().setText(text);
                }
            });
        }
    }

    class ComboPanel
    extends JPanel {
        JCheckBox checkBox = null;
        NumberComboBoxPanelCheckBox ncb = null;

        public void setSettings(Convention.Key checkbox, Convention.Key combobox) {
            if (checkbox == combobox) {
                if (this.checkBox.isSelected()) {
                    WrappingSettingsPage.this.settings.put(checkbox, String.valueOf(0));
                } else if (this.ncb.getCheckBox().isSelected()) {
                    WrappingSettingsPage.this.settings.put(checkbox, (String)this.ncb.getComboBoxPanel().getComboBox().getSelectedItem());
                } else {
                    WrappingSettingsPage.this.settings.putInt(checkbox, Integer.MAX_VALUE);
                }
            } else {
                if (this.ncb.getCheckBox().isSelected()) {
                    WrappingSettingsPage.this.settings.put(combobox, (String)this.ncb.getComboBoxPanel().getComboBox().getSelectedItem());
                } else {
                    WrappingSettingsPage.this.settings.putInt(combobox, Integer.MAX_VALUE);
                }
                WrappingSettingsPage.this.settings.putBoolean(checkbox, this.checkBox.isSelected());
            }
        }

        public JCheckBox getCheckBox() {
            return this.checkBox;
        }

        public NumberComboBoxPanelCheckBox getNCB() {
            return this.ncb;
        }

        public ComboPanel(String borderName, String chkBoxName, String ncbName, String comboName, int arrayElements, String[] items, GridBagConstraints c) {
            GridBagLayout enumPanelLayout = new GridBagLayout();
            this.setLayout(enumPanelLayout);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(borderName), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
            this.checkBox = new JCheckBox(chkBoxName, arrayElements == 0 || arrayElements == Integer.MAX_VALUE);
            this.checkBox.addActionListener(WrappingSettingsPage.this.trigger);
            SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
            enumPanelLayout.setConstraints(this.checkBox, c);
            this.add(this.checkBox);
            this.ncb = new NumberComboBoxPanelCheckBox(ncbName, arrayElements < Integer.MAX_VALUE && arrayElements > 0, comboName, items, this.getWrapValue(arrayElements));
            this.ncb.getCheckBox().addActionListener(WrappingSettingsPage.this.trigger);
            this.ncb.getComboBoxPanel().getComboBox().addActionListener(WrappingSettingsPage.this.trigger);
            SwingHelper.setConstraints(c, 0, 1, 0, 1, 1.0, 0.0, 17, 2, c.insets, 0, 0);
            enumPanelLayout.setConstraints(this.ncb, c);
            this.add(this.ncb);
            EmptyButtonGroup eButtonGroup = new EmptyButtonGroup();
            eButtonGroup.add(this.checkBox);
            eButtonGroup.add(this.ncb.getCheckBox());
        }

        private String getWrapValue(int value) {
            switch (value) {
                case 0: 
                case 0x7FFFFFFF: {
                    return "1";
                }
            }
            return String.valueOf(value);
        }
    }
}

