/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.BaseXMLElement;

public class OMXMLElement
extends BaseXMLElement {
    public OMXMLElement(ErrorReporter errorReporter) {
        super(errorReporter);
    }

    public void setSource(Object elem) {
        if (!(elem instanceof OMElement)) {
            String elemClass = elem != null ? elem.getClass().getName() : null;
            String xmlElementClass = this.getClass().getName();
            String msg = this.fErrorReporter.getFormattedMessage("WSDL019", new Object[]{elemClass, xmlElementClass});
            throw new IllegalArgumentException(msg);
        }
        this.fSource = elem;
    }

    protected String doGetAttributeValue(String attrName) {
        OMElement elem = (OMElement)this.fSource;
        return elem.getAttributeValue(new QName(attrName));
    }

    protected URI doGetNamespaceURI() throws WSDLException {
        OMElement elem = (OMElement)this.fSource;
        String nsStr = elem.getNamespace().getNamespaceURI();
        URI uri = null;
        try {
            uri = new URI(nsStr);
        }
        catch (URISyntaxException e) {
            String msg = this.fErrorReporter.getFormattedMessage("WSDL506", new Object[]{nsStr});
            throw new WSDLException("INVALID_WSDL", msg, e);
        }
        return uri;
    }

    protected String doGetLocalName() {
        OMElement elem = (OMElement)this.fSource;
        return elem.getLocalName();
    }

    protected QName doGetQName() {
        OMElement elem = (OMElement)this.fSource;
        return elem.getQName();
    }

    protected QName doGetQName(String prefixedValue) throws WSDLException {
        OMElement elem = (OMElement)this.fSource;
        int index = prefixedValue.indexOf(58);
        String prefix = index != -1 ? prefixedValue.substring(0, index) : null;
        String localPart = prefixedValue.substring(index + 1);
        if (prefix != null) {
            String namespaceURI = elem.findNamespaceURI(prefix).getNamespaceURI();
            return new QName(namespaceURI, localPart, prefix);
        }
        String faultCode = prefix == null ? "NO_PREFIX_SPECIFIED" : "UNBOUND_PREFIX";
        String msg = this.fErrorReporter.getFormattedMessage("WSDL513", new Object[]{prefixedValue, elem.getQName()});
        WSDLException wsdlExc = new WSDLException(faultCode, msg);
        throw wsdlExc;
    }

    protected XMLElement doGetFirstChildElement() {
        OMElement elem = (OMElement)this.fSource;
        OMXMLElement omXMLElement = new OMXMLElement(this.fErrorReporter);
        omXMLElement.setSource(elem.getFirstElement());
        return omXMLElement;
    }

    protected XMLElement doGetNextSiblingElement() {
        OMElement elem = (OMElement)this.fSource;
        OMXMLElement omXMLElement = new OMXMLElement(this.fErrorReporter);
        omXMLElement.setSource(elem.getNextOMSibling());
        return omXMLElement;
    }

    protected XMLElement[] doGetChildElements() {
        OMElement elem = (OMElement)this.fSource;
        Iterator elems = elem.getChildElements();
        Vector<OMXMLElement> children = new Vector<OMXMLElement>();
        Object next = elems.next();
        while (next != null) {
            OMXMLElement omXMLElement = new OMXMLElement(this.fErrorReporter);
            omXMLElement.setSource(next);
            children.add(omXMLElement);
            next = elems.next();
        }
        XMLElement[] array = new XMLElement[children.size()];
        children.toArray(array);
        return array;
    }
}

