/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.resolver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.resolver.SchemaResolverAdapter;
import org.apache.woden.resolver.URIResolver;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMSchemaResolverAdapter
extends SchemaResolverAdapter {
    public DOMSchemaResolverAdapter(URIResolver actualResolver, XMLElement schemaElement) {
        super(actualResolver, schemaElement);
    }

    protected InputStream resolveFragId(String fragId) {
        String id;
        Element contextEl = (Element)this.fContextElement.getSource();
        Document doc = contextEl.getOwnerDocument();
        Element schemaEl = doc.getElementById(id = fragId.substring(1));
        if (schemaEl == null) {
            return null;
        }
        String localName = schemaEl.getLocalName();
        if (!localName.equals("schema")) {
            return null;
        }
        String prefix = schemaEl.getPrefix();
        if (prefix != null) {
            String nsUri = schemaEl.getNamespaceURI();
            String schemaNSDecl = "xmlns:" + prefix;
            boolean isSchemaNSDeclared = schemaEl.hasAttribute(schemaNSDecl);
            if (!isSchemaNSDeclared) {
                schemaEl.setAttribute(schemaNSDecl, nsUri);
            }
        }
        OutputFormat format = new OutputFormat(doc);
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        XMLSerializer serializer = new XMLSerializer((OutputStream)oStream, format);
        try {
            serializer.serialize(schemaEl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ByteArrayInputStream iStream = new ByteArrayInputStream(oStream.toByteArray());
        return iStream;
    }
}

