/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.xml;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.util.StringUtils;
import org.apache.woden.internal.xml.XMLAttrImpl;
import org.apache.woden.xml.QNameListOrTokenAttr;

public class QNameListOrTokenAnyAttrImpl
extends XMLAttrImpl
implements QNameListOrTokenAttr {
    public boolean isQNameList() {
        return this.fContent instanceof QName[];
    }

    public boolean isToken() {
        return !this.isQNameList() && this.isValid();
    }

    public QName[] getQNames() {
        if (this.isQNameList()) {
            return (QName[])this.fContent;
        }
        return null;
    }

    public String getToken() {
        if (!this.isQNameList() && this.isValid()) {
            return (String)this.fContent;
        }
        return null;
    }

    protected Object convert(XMLElement ownerEl, String attrValue) throws WSDLException {
        if ("#any".equals(attrValue)) {
            return attrValue;
        }
        if (attrValue == null || "".equals(attrValue)) {
            this.setValid(false);
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL509", new Object[]{attrValue}, (short)2);
            return null;
        }
        List qnStrings = StringUtils.parseNMTokens(attrValue);
        Iterator i = qnStrings.iterator();
        Vector<QName> qnames = new Vector<QName>();
        while (i.hasNext()) {
            QName qname;
            String qnString = (String)i.next();
            try {
                qname = ownerEl.getQName(qnString);
            }
            catch (WSDLException e) {
                this.setValid(false);
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL510", new Object[]{qnString, attrValue}, (short)2, (Exception)e);
                continue;
            }
            qnames.add(qname);
        }
        QName[] qnArray = new QName[qnames.size()];
        qnames.toArray(qnArray);
        return qnArray;
    }
}

