/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.async;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.ws.Response;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.handler.AttachmentsAdapter;
import org.apache.axis2.jaxws.handler.HandlerChainProcessor;
import org.apache.axis2.jaxws.handler.HandlerInvokerUtils;
import org.apache.axis2.jaxws.handler.TransportHeadersAdapter;
import org.apache.axis2.jaxws.message.attachments.AttachmentUtils;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AsyncResponse
implements Response {
    private static final Log log = LogFactory.getLog(AsyncResponse.class);
    private boolean cancelled;
    private Throwable fault;
    private MessageContext faultMessageContext;
    private MessageContext response;
    private EndpointDescription endpointDescription;
    private Map<String, Object> responseContext;
    private CountDownLatch latch;
    private boolean cacheValid = false;
    private Object cachedObject = null;

    protected AsyncResponse(EndpointDescription ed) {
        this.endpointDescription = ed;
        this.latch = new CountDownLatch(1);
    }

    protected void onError(Throwable flt, MessageContext faultCtx) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"AsyncResponse received a fault.  Counting down latch.");
        }
        this.fault = flt;
        this.faultMessageContext = faultCtx;
        this.faultMessageContext.setEndpointDescription(this.endpointDescription);
        this.cacheValid = false;
        this.cachedObject = null;
        this.latch.countDown();
        if (log.isDebugEnabled()) {
            log.debug((Object)("New latch count = [" + this.latch.getCount() + "]"));
        }
    }

    protected void onComplete(MessageContext mc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"AsyncResponse received a MessageContext. Counting down latch.");
        }
        if (this.response != mc) {
            this.cachedObject = null;
            this.cacheValid = false;
        }
        this.response = mc;
        this.response.setEndpointDescription(this.endpointDescription);
        if (this.response.getAxisMessageContext().getAttachmentMap() != null) {
            AttachmentUtils.findCachedAttachment(this.response.getAxisMessageContext().getAttachmentMap());
        }
        this.latch.countDown();
        if (log.isDebugEnabled()) {
            log.debug((Object)("New latch count = [" + this.latch.getCount() + "]"));
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled || this.latch.getCount() == 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cancellation attempt failed.");
            }
            return false;
        }
        this.cancelled = true;
        return this.cancelled;
    }

    public Object get() throws InterruptedException, ExecutionException {
        if (this.cancelled) {
            throw new CancellationException("The task was cancelled.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Waiting for async response delivery.");
        }
        this.latch.await();
        Object obj = this.processResponse();
        return obj;
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.cancelled) {
            throw new CancellationException("The task was cancelled.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Waiting for async response delivery with time out.");
            log.debug((Object)("timeout = " + timeout));
            log.debug((Object)("units   = " + (Object)((Object)unit)));
        }
        this.latch.await(timeout, unit);
        if (this.latch.getCount() > 0L) {
            throw new TimeoutException("The client timed out while waiting for an asynchronous response");
        }
        Object obj = this.processResponse();
        return obj;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    public Map getContext() {
        return this.responseContext;
    }

    private Object processResponse() throws ExecutionException {
        if (this.fault != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"A fault was found.  Starting to process fault response.");
            }
            Throwable t = this.processFaultResponse();
            throw new ExecutionException(t);
        }
        if (this.response == null) {
            throw new ExecutionException(ExceptionFactory.makeWebServiceException((String)"null response"));
        }
        if (this.cacheValid) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Return object cached from last get()");
            }
            return this.cachedObject;
        }
        TransportHeadersAdapter.install(this.response);
        AttachmentsAdapter.install(this.response);
        HandlerInvokerUtils.invokeInboundHandlers(this.response.getMEPContext(), this.response.getInvocationContext().getHandlers(), HandlerChainProcessor.MEP.RESPONSE, false);
        Object obj = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unmarshalling the async response message.");
            }
            obj = this.getResponseValueObject(this.response);
            this.cacheValid = true;
            this.cachedObject = obj;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"An error occurred while processing the response");
            }
            throw new ExecutionException(ExceptionFactory.makeWebServiceException((Throwable)t));
        }
        if (log.isDebugEnabled() && obj != null) {
            log.debug((Object)("Unmarshalled response object of type: " + obj.getClass()));
        }
        this.responseContext = new HashMap<String, Object>();
        ApplicationContextMigratorUtil.performMigrationFromMessageContext("org.apache.axis2.jaxws.spi.ApplicationContextMigrators", this.responseContext, this.response);
        return obj;
    }

    private Throwable processFaultResponse() {
        if (this.faultMessageContext != null) {
            Throwable t;
            if (this.faultMessageContext.getMessage() != null) {
                HandlerInvokerUtils.invokeInboundHandlers(this.faultMessageContext.getMEPContext(), this.faultMessageContext.getInvocationContext().getHandlers(), HandlerChainProcessor.MEP.RESPONSE, false);
            }
            if ((t = this.getFaultResponse(this.faultMessageContext)) != null) {
                return t;
            }
            return ExceptionFactory.makeWebServiceException((Throwable)this.fault);
        }
        return ExceptionFactory.makeWebServiceException((Throwable)this.fault);
    }

    public abstract Object getResponseValueObject(MessageContext var1);

    public abstract Throwable getFaultResponse(MessageContext var1);
}

