/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.marshaller.impl.alt;

import java.util.List;
import java.util.TreeSet;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.MethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.Element;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.marshaller.impl.alt.PDElement;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RPCLitMethodMarshaller
implements MethodMarshaller {
    private static Log log = LogFactory.getLog(RPCLitMethodMarshaller.class);

    public Message marshalRequest(Object[] signatureArguments, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        Protocol protocol = Protocol.getProtocolForBinding(endpointDesc.getClientBindingID());
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            if (pds.length > 0) {
                if (signatureArguments == null) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NullParamErr1", (String)"Input", (String)operationDesc.getJavaMethodName(), (String)"rpc/lit"));
                }
                if (signatureArguments != null) {
                    for (Object argument : signatureArguments) {
                        if (argument != null) continue;
                        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NullParamErr1", (String)"Input", (String)operationDesc.getJavaMethodName(), (String)"rpc/lit"));
                    }
                }
            }
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            m.setStyle(SOAPBinding.Style.RPC);
            m.setOperationElement(RPCLitMethodMarshaller.getRPCOperationQName(operationDesc, true));
            List<PDElement> pdeList = MethodMarshallerUtils.getPDElements(marshalDesc, pds, signatureArguments, true, false, true);
            for (PDElement pde : pdeList) {
                ParameterDescription pd = pde.getParam();
                Class type = pd.getParameterActualType();
                if (pd.isHeader() && !MethodMarshallerUtils.isNotJAXBRootElement(type, marshalDesc)) continue;
                pde.setByJavaTypeClass(type);
            }
            MethodMarshallerUtils.toMessage(pdeList, m, packages);
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Object[] demarshalRequest(Message message, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            message.setStyle(SOAPBinding.Style.RPC);
            Class[] javaTypes = new Class[pds.length];
            for (int i = 0; i < pds.length; ++i) {
                ParameterDescription pd = pds[i];
                Class type = pd.getParameterActualType();
                if (pd.isHeader() && !MethodMarshallerUtils.isNotJAXBRootElement(type, marshalDesc)) continue;
                javaTypes[i] = type;
            }
            List<PDElement> pvList = MethodMarshallerUtils.getPDElements(pds, message, packages, true, false, javaTypes);
            Object[] sigArguments = MethodMarshallerUtils.createRequestSignatureArgs(pds, pvList);
            if (sigArguments != null) {
                for (Object argument : sigArguments) {
                    if (argument != null) continue;
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NullParamErr1", (String)"Input", (String)operationDesc.getJavaMethodName(), (String)"rpc/lit"));
                }
            }
            return sigArguments;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Message marshalResponse(Object returnObject, Object[] signatureArgs, OperationDescription operationDesc, Protocol protocol) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        if (protocol == null) {
            protocol = Protocol.getProtocolForBinding(endpointDesc.getBindingType());
        }
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            m.setStyle(SOAPBinding.Style.RPC);
            QName rpcOpQName = RPCLitMethodMarshaller.getRPCOperationQName(operationDesc, false);
            String localPart = rpcOpQName.getLocalPart() + "Response";
            QName responseOp = new QName(rpcOpQName.getNamespaceURI(), localPart, rpcOpQName.getPrefix());
            m.setOperationElement(responseOp);
            Class returnType = operationDesc.getResultActualType();
            String returnNS = null;
            String returnLocalPart = null;
            if (operationDesc.isResultHeader()) {
                returnNS = operationDesc.getResultTargetNamespace();
                returnLocalPart = operationDesc.getResultName();
            } else {
                returnNS = "";
                returnLocalPart = operationDesc.getResultPartName();
            }
            if (returnType != Void.TYPE) {
                if (returnObject == null) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NullParamErr1", (String)"Return", (String)operationDesc.getJavaMethodName(), (String)"rpc/lit"));
                }
                Element returnElement = null;
                QName returnQName = new QName(returnNS, returnLocalPart);
                returnElement = marshalDesc.getAnnotationDesc(returnType).hasXmlRootElement() ? new Element(returnObject, returnQName) : new Element(returnObject, returnQName, returnType);
                Class byJavaType = null;
                if (!operationDesc.isResultHeader() || MethodMarshallerUtils.isNotJAXBRootElement(returnType, marshalDesc)) {
                    byJavaType = returnType;
                }
                MethodMarshallerUtils.toMessage(returnElement, returnType, operationDesc.isListType(), marshalDesc, m, byJavaType, operationDesc.isResultHeader());
            }
            List<PDElement> pdeList = MethodMarshallerUtils.getPDElements(marshalDesc, pds, signatureArgs, false, false, true);
            for (PDElement pde : pdeList) {
                ParameterDescription pd = pde.getParam();
                Class type = pd.getParameterActualType();
                if (pd.isHeader() && !MethodMarshallerUtils.isNotJAXBRootElement(type, marshalDesc)) continue;
                pde.setByJavaTypeClass(type);
            }
            MethodMarshallerUtils.toMessage(pdeList, m, packages);
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Object demarshalResponse(Message message, Object[] signatureArgs, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            message.setStyle(SOAPBinding.Style.RPC);
            Class returnType = operationDesc.getResultActualType();
            Object returnValue = null;
            boolean hasReturnInBody = false;
            if (returnType != Void.TYPE) {
                Element returnElement = null;
                Class byJavaType = null;
                if (!operationDesc.isResultHeader() || MethodMarshallerUtils.isNotJAXBRootElement(returnType, marshalDesc)) {
                    byJavaType = returnType;
                }
                if (operationDesc.isResultHeader()) {
                    returnElement = MethodMarshallerUtils.getReturnElement(packages, message, byJavaType, operationDesc.isListType(), true, operationDesc.getResultTargetNamespace(), operationDesc.getResultPartName(), MethodMarshallerUtils.numOutputBodyParams(pds) > 0);
                } else {
                    returnElement = MethodMarshallerUtils.getReturnElement(packages, message, byJavaType, operationDesc.isListType(), false, null, null, MethodMarshallerUtils.numOutputBodyParams(pds) > 0);
                    hasReturnInBody = true;
                }
                returnValue = returnElement.getTypeValue();
                if (returnValue == null) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NullParamErr1", (String)"Return", (String)operationDesc.getJavaMethodName(), (String)"rpc/lit"));
                }
            }
            Class[] javaTypes = new Class[pds.length];
            for (int i = 0; i < pds.length; ++i) {
                ParameterDescription pd = pds[i];
                Class type = pd.getParameterActualType();
                if (pd.isHeader() && !MethodMarshallerUtils.isNotJAXBRootElement(type, marshalDesc)) continue;
                javaTypes[i] = type;
            }
            List<PDElement> pvList = MethodMarshallerUtils.getPDElements(pds, message, packages, false, hasReturnInBody, javaTypes);
            MethodMarshallerUtils.updateResponseSignatureArgs(pds, pvList, signatureArgs);
            return returnValue;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Message marshalFaultResponse(Throwable throwable, OperationDescription operationDesc, Protocol protocol) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        TreeSet<String> packages = marshalDesc.getPackages();
        if (protocol == null) {
            protocol = Protocol.getProtocolForBinding(endpointDesc.getBindingType());
        }
        try {
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            MethodMarshallerUtils.marshalFaultResponse(throwable, marshalDesc, operationDesc, m);
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Throwable demarshalFaultResponse(Message message, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        try {
            Throwable t = MethodMarshallerUtils.demarshalFaultResponse(operationDesc, marshalDesc, message);
            return t;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private static QName getRPCOperationQName(OperationDescription opDesc, boolean isRequest) {
        QName qName = opDesc.getName();
        String localPart = qName.getLocalPart();
        String uri = null;
        uri = isRequest ? opDesc.getBindingInputNamespace() : opDesc.getBindingOutputNamespace();
        String prefix = "rpcOp";
        qName = new QName(uri, localPart, prefix);
        return qName;
    }
}

