/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.databinding.SourceBlock;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.impl.BlockImpl;
import org.apache.axis2.jaxws.message.util.Reader2Writer;
import org.apache.axis2.jaxws.utility.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SourceBlockImpl
extends BlockImpl
implements SourceBlock {
    private static final Log log = LogFactory.getLog(SourceBlockImpl.class);
    private static Class staxSource = null;

    SourceBlockImpl(Source busObject, QName qName, BlockFactory factory) throws WebServiceException {
        super(busObject, null, qName, factory);
        if (!(busObject instanceof DOMSource || busObject instanceof SAXSource || busObject instanceof StreamSource || busObject.getClass().equals(staxSource) || busObject instanceof JAXBSource)) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceNotSupported", (String)busObject.getClass().getName()));
        }
    }

    public SourceBlockImpl(OMElement omElement, QName qName, BlockFactory factory) {
        super(omElement, (Object)null, qName, factory);
    }

    protected Object _getBOFromReader(XMLStreamReader reader, Object busContext) throws XMLStreamException {
        if (staxSource != null) {
            try {
                Constructor c = staxSource.getDeclaredConstructor(XMLStreamReader.class);
                return c.newInstance(reader);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Reader2Writer r2w = new Reader2Writer(reader);
        String text = r2w.getAsString();
        StringReader sr = new StringReader(text);
        return new StreamSource(sr);
    }

    protected XMLStreamReader _getReaderFromBO(Object busObj, Object busContext) throws XMLStreamException, WebServiceException {
        try {
            if (busObj instanceof StreamSource) {
                XMLInputFactory f = StAXUtils.getXMLInputFactory();
                XMLStreamReader reader = f.createXMLStreamReader((Source)busObj);
                StAXUtils.releaseXMLInputFactory((XMLInputFactory)f);
                return reader;
            }
            return this._slow_getReaderFromSource((Source)busObj);
        }
        catch (Exception e) {
            String className = busObj == null ? "none" : busObj.getClass().getName();
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceReadErr", (String)className), (Throwable)e);
        }
    }

    private XMLStreamReader _slow_getReaderFromSource(Source src) throws XMLStreamException {
        byte[] bytes = (byte[])ConvertUtils.convert(src, byte[].class);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return StAXUtils.createXMLStreamReader((InputStream)bais);
    }

    protected void _outputFromBO(Object busObject, Object busContext, XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        XMLStreamReader reader = this._getReaderFromBO(busObject, busContext);
        this._outputFromReader(reader, writer);
    }

    protected Object _getBOFromBO(Object busObject, Object busContext, boolean consume) {
        if (consume) {
            return busObject;
        }
        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceMissingSupport", (String)busObject.getClass().getName()));
    }

    public boolean isElementData() {
        return false;
    }

    private static Class forName(final String className) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    public Object getBusinessObject(boolean consume) throws XMLStreamException, WebServiceException {
        if (this.consumed) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"BlockImplErr1", (String)this.getClass().getName()));
        }
        if (this.busObject != null) {
            this.busObject = this._getBOFromBO(this.busObject, this.busContext, consume);
        } else {
            boolean hasFault = false;
            if (this.parent != null && this.parent.isFault() || this.omElement.getQName().getLocalPart().equals("Fault")) {
                hasFault = true;
            }
            if (!hasFault) {
                XMLStreamReader reader = this.omElement.getBuilder() != null && !this.omElement.getBuilder().isCompleted() ? this.omElement.getXMLStreamReaderWithoutCaching() : this.omElement.getXMLStreamReader();
                this.busObject = this._getBOFromReader(reader, this.busContext);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.omElement.serialize((OutputStream)baos);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                this.busObject = new StreamSource(bais);
            }
            this.omElement = null;
        }
        Object newBusObject = this.busObject;
        this.setConsumed(consume);
        return newBusObject;
    }

    static {
        try {
            staxSource = SourceBlockImpl.forName("javax.xml.transform.stax.StAXSource");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (XMLInputFactory.newInstance().getClass().getName().indexOf("wstx") != -1) {
                staxSource = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

