/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.dispatcher;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.PrivilegedExceptionAction;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.util.MessageContextUtils;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.XMLFault;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.message.factory.SOAPEnvelopeBlockFactory;
import org.apache.axis2.jaxws.message.factory.SourceBlockFactory;
import org.apache.axis2.jaxws.message.factory.XMLStringBlockFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.EndpointController;
import org.apache.axis2.jaxws.server.dispatcher.JavaDispatcher;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderDispatcher
extends JavaDispatcher {
    private static Log log = LogFactory.getLog(ProviderDispatcher.class);
    private BlockFactory blockFactory = null;
    private Class providerType = null;
    private Provider providerInstance = null;
    private Service.Mode providerServiceMode = null;
    private Message message = null;
    private Protocol messageProtocol;

    public ProviderDispatcher(Class _class, Object serviceInstance) {
        super(_class, serviceInstance);
    }

    @Override
    public MessageContext invoke(final MessageContext mc) throws Exception {
        Object responseParamValue;
        XMLFault fault;
        boolean faultThrown;
        EndpointDescription endpointDesc;
        block20: {
            Object input;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Preparing to invoke javax.xml.ws.Provider based endpoint");
            }
            this.providerInstance = this.getProviderInstance();
            this.providerType = this.getProviderType();
            endpointDesc = mc.getEndpointDescription();
            Object requestParamValue = null;
            Message message = mc.getMessage();
            if (message != null) {
                String bindingType = endpointDesc.getBindingType();
                if (bindingType != null && (bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true"))) {
                    message.setMTOMEnabled(true);
                }
                this.messageProtocol = message.getProtocol();
                BlockFactory factory = this.createBlockFactory(this.providerType);
                this.providerServiceMode = endpointDesc.getServiceMode();
                if (this.providerServiceMode != null && this.providerServiceMode == Service.Mode.MESSAGE) {
                    if (this.providerType.equals(SOAPMessage.class) && log.isDebugEnabled()) {
                        log.debug((Object)"Provider Type is SOAPMessage.");
                        log.debug((Object)("Number Message attachments=" + message.getAttachmentIDs().size()));
                    }
                    if ((requestParamValue = message.getValue(null, factory)) == null && log.isDebugEnabled()) {
                        log.debug((Object)"There are no elements to unmarshal.  ProviderDispatch will pass a null as input");
                    }
                } else {
                    Block block = message.getBodyBlock(null, factory);
                    if (block != null) {
                        requestParamValue = block.getBusinessObject(true);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"No body blocks in SOAPMessage, Calling provider method with null input parameters");
                        }
                        requestParamValue = null;
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Provider Type = " + this.providerType + "; parameter type = " + requestParamValue));
            }
            if ((input = this.providerType.cast(requestParamValue)) != null && log.isDebugEnabled()) {
                log.debug((Object)("Invoking Provider<" + this.providerType.getName() + "> with " + "parameter of type " + input.getClass().getName()));
            }
            if (input == null && log.isDebugEnabled()) {
                log.debug((Object)("Invoking Provider<" + this.providerType.getName() + "> with " + "NULL input parameter"));
            }
            faultThrown = false;
            fault = null;
            responseParamValue = null;
            Throwable t = null;
            try {
                responseParamValue = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ProviderDispatcher.this.invokeProvider(mc, ProviderDispatcher.this.providerInstance, input);
                    }
                });
            }
            catch (Exception e) {
                t = ClassUtils.getRootCause(e);
                faultThrown = true;
                fault = MethodMarshallerUtils.createXMLFaultFromSystemException(t);
                if (!log.isDebugEnabled()) break block20;
                log.debug((Object)("Marshal Throwable =" + e.getClass().getName()));
                log.debug((Object)("  rootCause =" + t.getClass().getName()));
                log.debug((Object)("  exception=" + t.toString()));
            }
        }
        MessageContext responseMsgCtx = null;
        if (!EndpointController.isOneWay(mc.getAxisMessageContext())) {
            if (faultThrown) {
                Message responseMsg = this.createMessageFromValue(fault);
                responseMsgCtx = MessageContextUtils.createFaultMessageContext(mc);
                responseMsgCtx.setMessage(responseMsg);
            } else {
                Message responseMsg = this.createMessageFromValue(responseParamValue);
                String bindingType = endpointDesc.getBindingType();
                if (bindingType != null && (bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true"))) {
                    responseMsg.setMTOMEnabled(true);
                }
                responseMsgCtx = MessageContextUtils.createResponseMessageContext(mc);
                responseMsgCtx.setMessage(responseMsg);
            }
        } else {
            return null;
        }
        return responseMsgCtx;
    }

    protected Object invokeProvider(MessageContext ctx, Provider provider, Object input) throws Exception {
        return provider.invoke(input);
    }

    public Provider getProvider() throws Exception {
        Provider p = this.getProviderInstance();
        this.setProvider(p);
        return p;
    }

    public void setProvider(Provider _provider) {
        this.providerInstance = _provider;
    }

    public Message getMessage() throws Exception {
        return this.message;
    }

    public void setMessage(Message msg) {
        this.message = msg;
    }

    private Message createMessageFromValue(Object value) throws Exception {
        MessageFactory msgFactory = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
        Message message = null;
        if (value != null) {
            BlockFactory factory = this.createBlockFactory(this.providerType);
            if (value instanceof XMLFault) {
                message = msgFactory.create(this.messageProtocol);
                message.setXMLFault((XMLFault)value);
            } else if (this.providerServiceMode != null && this.providerServiceMode == Service.Mode.MESSAGE) {
                if (value instanceof SOAPMessage) {
                    message = msgFactory.createFrom((SOAPMessage)value);
                } else {
                    Block block = factory.createFrom(value, null, null);
                    message = msgFactory.createFrom(block, null, this.messageProtocol);
                }
            } else {
                Block block = factory.createFrom(value, null, null);
                message = msgFactory.create(this.messageProtocol);
                message.setBodyBlock(block);
            }
        }
        if (message == null) {
            message = msgFactory.create(this.messageProtocol);
        }
        return message;
    }

    private Provider getProviderInstance() throws Exception {
        Class<?> clazz = this.getProviderType();
        if (!this.isValidProviderType(clazz)) {
            throw new Exception(Messages.getMessage((String)"InvalidProvider", (String)clazz.getName()));
        }
        Provider provider = null;
        if (clazz == String.class) {
            provider = (Provider)this.serviceInstance;
        } else if (clazz == Source.class) {
            provider = (Provider)this.serviceInstance;
        } else if (clazz == SOAPMessage.class) {
            provider = (Provider)this.serviceInstance;
        } else if (clazz == JAXBContext.class) {
            provider = (Provider)this.serviceInstance;
        }
        if (provider == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"InvalidProviderCreate", (String)clazz.getName()));
        }
        return provider;
    }

    private Class<?> getProviderType() throws Exception {
        Type[] giTypes;
        Class providerType = null;
        for (Type giType : giTypes = this.serviceImplClass.getGenericInterfaces()) {
            ParameterizedType paramType = null;
            try {
                paramType = (ParameterizedType)giType;
            }
            catch (ClassCastException e) {
                throw new Exception("Provider based SEI Class has to implement javax.xml.ws.Provider as javax.xml.ws.Provider<String>, javax.xml.ws.Provider<SOAPMessage>, javax.xml.ws.Provider<Source> or javax.xml.ws.Provider<JAXBContext>");
            }
            Class interfaceName = (Class)paramType.getRawType();
            if (interfaceName != Provider.class) continue;
            if (paramType.getActualTypeArguments().length > 1) {
                throw new Exception("Provider cannot have more than one Generic Types defined as Per JAX-WS Specification");
            }
            providerType = (Class)paramType.getActualTypeArguments()[0];
        }
        return providerType;
    }

    private boolean isValidProviderType(Class clazz) {
        boolean valid;
        boolean bl = valid = clazz == String.class || clazz == SOAPMessage.class || clazz == Source.class || clazz == DataSource.class;
        if (!valid && log.isDebugEnabled()) {
            log.debug((Object)("Class " + clazz.getName() + " is not a valid Provider<T> type"));
        }
        return valid;
    }

    private BlockFactory createBlockFactory(Class type) {
        if (this.blockFactory != null) {
            return this.blockFactory;
        }
        if (type.equals(String.class)) {
            this.blockFactory = (XMLStringBlockFactory)FactoryRegistry.getFactory(XMLStringBlockFactory.class);
        } else if (type.equals(Source.class)) {
            this.blockFactory = (SourceBlockFactory)FactoryRegistry.getFactory(SourceBlockFactory.class);
        } else if (type.equals(SOAPMessage.class)) {
            this.blockFactory = (SOAPEnvelopeBlockFactory)FactoryRegistry.getFactory(SOAPEnvelopeBlockFactory.class);
        } else {
            ExceptionFactory.makeWebServiceException((String)("Unable to find BlockFactory for type: " + type.getClass().getName()));
        }
        return this.blockFactory;
    }
}

