/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes;

import java.util.ArrayList;
import org.apache.catalina.tribes.Member;

public class ChannelException
extends Exception {
    private ArrayList faultyMembers = null;

    public ChannelException() {
    }

    public ChannelException(String message) {
        super(message);
    }

    public ChannelException(String message, Throwable cause) {
        super(message, cause);
    }

    public ChannelException(Throwable cause) {
        super(cause);
    }

    public String getMessage() {
        StringBuffer buf = new StringBuffer(super.getMessage());
        if (this.faultyMembers == null || this.faultyMembers.size() == 0) {
            buf.append("; No faulty members identified.");
        } else {
            buf.append("; Faulty members:");
            for (int i = 0; i < this.faultyMembers.size(); ++i) {
                FaultyMember mbr = (FaultyMember)this.faultyMembers.get(i);
                buf.append(mbr.getMember().getName());
                buf.append("; ");
            }
        }
        return buf.toString();
    }

    public void addFaultyMember(Member mbr, Exception x) {
        this.addFaultyMember(new FaultyMember(mbr, x));
    }

    public void addFaultyMember(FaultyMember[] mbrs) {
        for (int i = 0; mbrs != null && i < mbrs.length; ++i) {
            this.addFaultyMember(mbrs[i]);
        }
    }

    public void addFaultyMember(FaultyMember mbr) {
        if (this.faultyMembers == null) {
            this.faultyMembers = new ArrayList();
        }
        this.faultyMembers.add(mbr);
    }

    public FaultyMember[] getFaultyMembers() {
        if (this.faultyMembers == null) {
            return new FaultyMember[0];
        }
        return this.faultyMembers.toArray(new FaultyMember[this.faultyMembers.size()]);
    }

    public static class FaultyMember {
        protected Exception cause;
        protected Member member;

        public FaultyMember(Member mbr, Exception x) {
            this.member = mbr;
            this.cause = x;
        }

        public Member getMember() {
            return this.member;
        }

        public Exception getCause() {
            return this.cause;
        }

        public String toString() {
            return "FaultyMember:" + this.member.toString();
        }
    }
}

