/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.HttpConnectionMetricsImpl;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.nio.codecs.ChunkDecoder;
import org.apache.http.impl.nio.codecs.ChunkEncoder;
import org.apache.http.impl.nio.codecs.IdentityDecoder;
import org.apache.http.impl.nio.codecs.IdentityEncoder;
import org.apache.http.impl.nio.codecs.LengthDelimitedDecoder;
import org.apache.http.impl.nio.codecs.LengthDelimitedEncoder;
import org.apache.http.impl.nio.reactor.SessionInputBuffer;
import org.apache.http.impl.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionBufferStatus;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.SyncHttpExecutionContext;
import org.apache.http.util.CharArrayBuffer;

public class NHttpConnectionBase
implements NHttpConnection,
HttpInetConnection,
SessionBufferStatus {
    protected final IOSession session;
    protected final HttpContext context;
    protected final ContentLengthStrategy incomingContentStrategy;
    protected final ContentLengthStrategy outgoingContentStrategy;
    protected final SessionInputBuffer inbuf;
    protected final SessionOutputBuffer outbuf;
    protected final CharArrayBuffer lineBuffer;
    protected final HttpConnectionMetricsImpl metrics;
    protected volatile ContentDecoder contentDecoder;
    protected volatile boolean hasBufferedInput;
    protected volatile ContentEncoder contentEncoder;
    protected volatile boolean hasBufferedOutput;
    protected volatile HttpRequest request;
    protected volatile HttpResponse response;
    protected volatile boolean closed;

    public NHttpConnectionBase(IOSession session, ByteBufferAllocator allocator, HttpParams params) {
        if (session == null) {
            throw new IllegalArgumentException("I/O session may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP params may not be null");
        }
        this.session = session;
        this.context = new SyncHttpExecutionContext(null);
        int buffersize = HttpConnectionParams.getSocketBufferSize((HttpParams)params);
        int linebuffersize = buffersize;
        if (linebuffersize > 512) {
            linebuffersize = 512;
        }
        this.inbuf = new SessionInputBuffer(buffersize, linebuffersize, allocator);
        this.inbuf.reset(params);
        this.outbuf = new SessionOutputBuffer(buffersize, linebuffersize, allocator);
        this.outbuf.reset(params);
        this.lineBuffer = new CharArrayBuffer(64);
        this.incomingContentStrategy = new LaxContentLengthStrategy();
        this.outgoingContentStrategy = new StrictContentLengthStrategy();
        this.metrics = new HttpConnectionMetricsImpl(null, null);
        this.closed = false;
        this.session.setBufferStatus(this);
        this.session.setEvent(1);
    }

    public HttpContext getContext() {
        return this.context;
    }

    public HttpRequest getHttpRequest() {
        return this.request;
    }

    public HttpResponse getHttpResponse() {
        return this.response;
    }

    public void requestInput() {
        this.session.setEvent(1);
    }

    public void requestOutput() {
        this.session.setEvent(4);
    }

    public void suspendInput() {
        this.session.clearEvent(1);
    }

    public void suspendOutput() {
        this.session.clearEvent(4);
    }

    protected HttpEntity prepareDecoder(HttpMessage message) throws HttpException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.incomingContentStrategy.determineLength(message);
        if (len == -2L) {
            this.contentDecoder = new ChunkDecoder(this.session.channel(), this.inbuf);
            entity.setChunked(true);
            entity.setContentLength(-1L);
        } else if (len == -1L) {
            this.contentDecoder = new IdentityDecoder(this.session.channel(), this.inbuf);
            entity.setChunked(false);
            entity.setContentLength(-1L);
        } else {
            this.contentDecoder = new LengthDelimitedDecoder(this.session.channel(), this.inbuf, len);
            entity.setChunked(false);
            entity.setContentLength(len);
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    protected void prepareEncoder(HttpMessage message) throws HttpException {
        long len = this.outgoingContentStrategy.determineLength(message);
        this.contentEncoder = len == -2L ? new ChunkEncoder(this.outbuf) : (len == -1L ? new IdentityEncoder(this.session.channel()) : new LengthDelimitedEncoder(this.session.channel(), len));
    }

    public boolean hasBufferedInput() {
        return this.hasBufferedInput;
    }

    public boolean hasBufferedOutput() {
        return this.hasBufferedOutput;
    }

    protected void assertNotClosed() throws IOException {
        if (this.closed) {
            throw new ConnectionClosedException("Connection is closed");
        }
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.outbuf.hasData()) {
            this.session.setEvent(4);
        } else {
            this.session.close();
        }
    }

    public boolean isOpen() {
        return !this.closed && !this.session.isClosed();
    }

    public boolean isStale() {
        return this.session.isClosed();
    }

    public InetAddress getLocalAddress() {
        SocketAddress address = this.session.getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getAddress();
        }
        return null;
    }

    public int getLocalPort() {
        SocketAddress address = this.session.getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getPort();
        }
        return -1;
    }

    public InetAddress getRemoteAddress() {
        SocketAddress address = this.session.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getAddress();
        }
        return null;
    }

    public int getRemotePort() {
        SocketAddress address = this.session.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getPort();
        }
        return -1;
    }

    public void setSocketTimeout(int timeout) {
        this.session.setSocketTimeout(timeout);
    }

    public int getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    public void shutdown() throws IOException {
        this.closed = true;
        this.session.shutdown();
    }

    public HttpConnectionMetrics getMetrics() {
        return this.metrics;
    }
}

