/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.codecs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.http.impl.nio.codecs.AbstractContentDecoder;
import org.apache.http.impl.nio.reactor.SessionInputBuffer;
import org.apache.http.nio.FileContentDecoder;

public class IdentityDecoder
extends AbstractContentDecoder
implements FileContentDecoder {
    public IdentityDecoder(ReadableByteChannel channel, SessionInputBuffer buffer) {
        super(channel, buffer);
    }

    public int read(ByteBuffer dst) throws IOException {
        if (dst == null) {
            throw new IllegalArgumentException("Byte buffer may not be null");
        }
        if (this.completed) {
            return -1;
        }
        int bytesRead = this.buffer.hasData() ? this.buffer.read(dst) : this.channel.read(dst);
        if (bytesRead == -1) {
            this.completed = true;
        }
        return bytesRead;
    }

    public long read(FileChannel fileChannel, long position, long count) throws IOException {
        long bytesRead;
        if (fileChannel == null) {
            return 0L;
        }
        if (this.completed) {
            return 0L;
        }
        if (this.buffer.hasData()) {
            ByteBuffer tmpDst = ByteBuffer.allocate((int)count);
            this.buffer.read(tmpDst);
            tmpDst.flip();
            bytesRead = fileChannel.write(tmpDst);
        } else {
            bytesRead = fileChannel.transferFrom(this.channel, position, count);
        }
        if (bytesRead == 0L) {
            this.completed = true;
        }
        return bytesRead;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[identity; completed: ");
        buffer.append(this.completed);
        buffer.append("]");
        return buffer.toString();
    }
}

