/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.codecs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.http.impl.nio.codecs.AbstractContentEncoder;
import org.apache.http.nio.FileContentEncoder;

public class IdentityEncoder
extends AbstractContentEncoder
implements FileContentEncoder {
    private final WritableByteChannel channel;

    public IdentityEncoder(WritableByteChannel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("Channel may not be null");
        }
        this.channel = channel;
    }

    public int write(ByteBuffer src) throws IOException {
        if (src == null) {
            return 0;
        }
        this.assertNotCompleted();
        return this.channel.write(src);
    }

    public long write(FileChannel filechannel, long position, long count) throws IOException {
        if (this.channel == null) {
            return 0L;
        }
        this.assertNotCompleted();
        return filechannel.transferTo(position, count, this.channel);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[identity; completed: ");
        buffer.append(this.completed);
        buffer.append("]");
        return buffer.toString();
    }
}

