/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.impl.nio.reactor.AbstractMultiworkerIOReactor;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.impl.nio.reactor.SessionRequestHandle;
import org.apache.http.impl.nio.reactor.SessionRequestImpl;
import org.apache.http.impl.nio.reactor.SessionRequestQueue;
import org.apache.http.nio.params.HttpNIOParams;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.nio.reactor.SessionRequestCallback;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.concurrent.ThreadFactory;

public class DefaultConnectingIOReactor
extends AbstractMultiworkerIOReactor
implements ConnectingIOReactor {
    private volatile boolean closed = false;
    private final HttpParams params;
    private final Selector selector;
    private final SessionRequestQueue requestQueue;
    private long lastTimeoutCheck;

    public DefaultConnectingIOReactor(int workerCount, ThreadFactory threadFactory, HttpParams params) throws IOReactorException {
        super(HttpNIOParams.getSelectInterval(params), workerCount, threadFactory);
        this.params = params;
        this.requestQueue = new SessionRequestQueue();
        this.lastTimeoutCheck = System.currentTimeMillis();
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new IOReactorException("Failure opening selector", ex);
        }
    }

    public DefaultConnectingIOReactor(int workerCount, HttpParams params) throws IOReactorException {
        this(workerCount, null, params);
    }

    public void execute(IOEventDispatch eventDispatch) throws InterruptedIOException, IOReactorException {
        if (eventDispatch == null) {
            throw new IllegalArgumentException("Event dispatcher may not be null");
        }
        this.startWorkers(eventDispatch);
        while (true) {
            long currentTime;
            int readyCount;
            try {
                readyCount = this.selector.select(this.getSelectTimeout());
            }
            catch (InterruptedIOException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw new IOReactorException("Unexpected selector failure", ex);
            }
            if (this.closed) break;
            this.processSessionRequests();
            if (readyCount > 0) {
                this.processEvents(this.selector.selectedKeys());
            }
            if ((currentTime = System.currentTimeMillis()) - this.lastTimeoutCheck >= this.getSelectTimeout()) {
                this.lastTimeoutCheck = currentTime;
                Set<SelectionKey> keys = this.selector.keys();
                if (keys != null) {
                    this.processTimeouts(keys);
                }
            }
            this.verifyWorkers();
        }
    }

    private void processEvents(Set selectedKeys) {
        Iterator it = selectedKeys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            this.processEvent(key);
        }
        selectedKeys.clear();
    }

    private void processEvent(SelectionKey key) {
        block7: {
            try {
                if (!key.isConnectable()) break block7;
                SocketChannel channel = (SocketChannel)key.channel();
                SessionRequestHandle requestHandle = (SessionRequestHandle)key.attachment();
                SessionRequestImpl sessionRequest = requestHandle.getSessionRequest();
                try {
                    channel.finishConnect();
                }
                catch (IOException ex) {
                    sessionRequest.failed(ex);
                }
                key.cancel();
                if (channel.isConnected()) {
                    try {
                        this.prepareSocket(channel.socket());
                        ChannelEntry entry = new ChannelEntry(channel, sessionRequest);
                        this.addChannel(entry);
                    }
                    catch (IOException ex) {
                        sessionRequest.failed(ex);
                    }
                }
            }
            catch (CancelledKeyException ex) {
                key.attach(null);
            }
        }
    }

    protected void prepareSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay((HttpParams)this.params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout((HttpParams)this.params));
        int linger = HttpConnectionParams.getLinger((HttpParams)this.params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
    }

    private void processTimeouts(Set keys) {
        long now = System.currentTimeMillis();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            SessionRequestHandle handle;
            SessionRequestImpl sessionRequest;
            int timeout;
            SelectionKey key = (SelectionKey)it.next();
            Object attachment = key.attachment();
            if (!(attachment instanceof SessionRequestHandle) || (timeout = (sessionRequest = (handle = (SessionRequestHandle)key.attachment()).getSessionRequest()).getConnectTimeout()) <= 0 || handle.getRequestTime() + (long)timeout >= now) continue;
            sessionRequest.timeout();
        }
    }

    public SessionRequest connect(SocketAddress remoteAddress, SocketAddress localAddress, Object attachment, SessionRequestCallback callback) {
        SessionRequestImpl sessionRequest = new SessionRequestImpl(remoteAddress, localAddress, attachment, callback);
        sessionRequest.setConnectTimeout(HttpConnectionParams.getConnectionTimeout((HttpParams)this.params));
        this.requestQueue.push(sessionRequest);
        this.selector.wakeup();
        return sessionRequest;
    }

    private void validateAddress(SocketAddress address) throws UnknownHostException {
        InetSocketAddress endpoint;
        if (address == null) {
            return;
        }
        if (address instanceof InetSocketAddress && (endpoint = (InetSocketAddress)address).isUnresolved()) {
            throw new UnknownHostException(endpoint.getHostName());
        }
    }

    private void processSessionRequests() throws IOReactorException {
        SessionRequestImpl request;
        while ((request = this.requestQueue.pop()) != null) {
            SelectionKey key;
            SocketChannel socketChannel;
            if (request.isCompleted()) continue;
            try {
                socketChannel = SocketChannel.open();
                socketChannel.configureBlocking(false);
            }
            catch (IOException ex) {
                throw new IOReactorException("Failure opening socket", ex);
            }
            try {
                this.validateAddress(request.getLocalAddress());
                this.validateAddress(request.getRemoteAddress());
                if (request.getLocalAddress() != null) {
                    socketChannel.socket().bind(request.getLocalAddress());
                }
                socketChannel.connect(request.getRemoteAddress());
            }
            catch (IOException ex) {
                request.failed(ex);
                return;
            }
            try {
                key = socketChannel.register(this.selector, 0);
                request.setKey(key);
            }
            catch (IOException ex) {
                throw new IOReactorException("Failure registering channel with the selector", ex);
            }
            SessionRequestHandle requestHandle = new SessionRequestHandle(request);
            try {
                key.attach(requestHandle);
                key.interestOps(8);
            }
            catch (CancelledKeyException ex) {}
        }
    }

    public void shutdown() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.selector.close();
        this.stopWorkers(500);
    }
}

