/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.impl.nio.reactor.SessionClosedCallback;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionBufferStatus;

public class IOSessionImpl
implements IOSession {
    private volatile boolean closed = false;
    private final SelectionKey key;
    private final ByteChannel channel;
    private final SessionClosedCallback callback;
    private final Map attributes;
    private SessionBufferStatus bufferStatus;
    private int socketTimeout;

    public IOSessionImpl(SelectionKey key, SessionClosedCallback callback) {
        if (key == null) {
            throw new IllegalArgumentException("Selection key may not be null");
        }
        this.key = key;
        this.channel = (ByteChannel)((Object)this.key.channel());
        this.callback = callback;
        this.attributes = Collections.synchronizedMap(new HashMap());
        this.socketTimeout = 0;
    }

    public ByteChannel channel() {
        return this.channel;
    }

    public SocketAddress getLocalAddress() {
        SelectableChannel channel = this.key.channel();
        if (channel instanceof SocketChannel) {
            return ((SocketChannel)channel).socket().getLocalSocketAddress();
        }
        return null;
    }

    public SocketAddress getRemoteAddress() {
        SelectableChannel channel = this.key.channel();
        if (channel instanceof SocketChannel) {
            return ((SocketChannel)channel).socket().getRemoteSocketAddress();
        }
        return null;
    }

    public int getEventMask() {
        return this.key.interestOps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventMask(int ops) {
        if (this.closed) {
            return;
        }
        SelectionKey selectionKey = this.key;
        synchronized (selectionKey) {
            this.key.interestOps(ops);
            this.key.selector().wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEvent(int op) {
        if (this.closed) {
            return;
        }
        SelectionKey selectionKey = this.key;
        synchronized (selectionKey) {
            int ops = this.key.interestOps();
            this.key.interestOps(ops | op);
            this.key.selector().wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEvent(int op) {
        if (this.closed) {
            return;
        }
        SelectionKey selectionKey = this.key;
        synchronized (selectionKey) {
            int ops = this.key.interestOps();
            this.key.interestOps(ops & ~op);
            this.key.selector().wakeup();
        }
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.key.cancel();
        try {
            this.key.channel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.callback != null) {
            this.callback.sessionClosed(this);
        }
        if (this.key.selector().isOpen()) {
            this.key.selector().wakeup();
        }
    }

    public boolean isClosed() {
        return this.closed || !this.key.isValid();
    }

    public void shutdown() {
        this.close();
    }

    public boolean hasBufferedInput() {
        return this.bufferStatus != null && this.bufferStatus.hasBufferedInput();
    }

    public boolean hasBufferedOutput() {
        return this.bufferStatus != null && this.bufferStatus.hasBufferedOutput();
    }

    public void setBufferStatus(SessionBufferStatus bufferStatus) {
        this.bufferStatus = bufferStatus;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public void setAttribute(String name, Object obj) {
        this.attributes.put(name, obj);
    }

    private static void formatOps(StringBuffer buffer, int ops) {
        buffer.append('[');
        if ((ops & 1) > 0) {
            buffer.append('r');
        }
        if ((ops & 4) > 0) {
            buffer.append('w');
        }
        if ((ops & 0x10) > 0) {
            buffer.append('a');
        }
        if ((ops & 8) > 0) {
            buffer.append('c');
        }
        buffer.append(']');
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.key.isValid()) {
            buffer.append("interested ops: ");
            IOSessionImpl.formatOps(buffer, this.key.interestOps());
            buffer.append("; ready ops: ");
            IOSessionImpl.formatOps(buffer, this.key.readyOps());
        } else {
            buffer.append("invalid");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

