/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.Writer;
import org.jibx.runtime.ICharacterEscaper;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.XMLWriterBase;

public class GenericXMLWriter
extends XMLWriterBase {
    private Writer m_writer;
    private ICharacterEscaper m_escaper;
    private boolean m_indent;
    private int m_indentBase;
    private int m_indentPerLevel;
    private char[] m_indentSequence;

    public GenericXMLWriter(String[] uris) {
        super(uris);
    }

    public GenericXMLWriter(GenericXMLWriter base, String[] uris) {
        super(base, uris);
        this.setOutput(base.m_writer, base.m_escaper);
        this.m_indent = base.m_indent;
        this.m_indentBase = base.m_indentBase;
        this.m_indentPerLevel = base.m_indentPerLevel;
        this.m_indentSequence = base.m_indentSequence;
    }

    public void setOutput(Writer outw, ICharacterEscaper escaper) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_writer = outw;
        this.m_escaper = escaper;
        this.reset();
    }

    public void setIndentSpaces(int count, String newline, char indent) {
        if (count >= 0) {
            if (newline == null) {
                newline = "\n";
            }
            this.m_indent = true;
            this.m_indentBase = newline.length();
            this.m_indentPerLevel = count;
            int length = newline.length() + count * 10;
            this.m_indentSequence = new char[length];
            for (int i = 0; i < length; ++i) {
                this.m_indentSequence[i] = i < newline.length() ? newline.charAt(i) : indent;
            }
        } else {
            this.m_indent = false;
        }
    }

    protected void writeMarkup(String text) throws IOException {
        this.m_writer.write(text);
    }

    protected void writeMarkup(char chr) throws IOException {
        this.m_writer.write(chr);
    }

    protected void defineNamespace(int index, String prefix) {
    }

    protected void undefineNamespace(int index) {
    }

    protected void writePrefix(int index) throws IOException {
        try {
            String text = this.getNamespacePrefix(index);
            if (text.length() > 0) {
                this.m_writer.write(text);
                this.m_writer.write(58);
            }
        }
        catch (NullPointerException ex) {
            throw new IOException("Namespace URI has not been declared.");
        }
    }

    protected void writeAttributeText(String text) throws IOException {
        this.m_escaper.writeAttribute(text, this.m_writer);
    }

    public void writeTextContent(String text) throws IOException {
        this.flagTextContent();
        this.m_escaper.writeContent(text, this.m_writer);
    }

    public void writeCData(String text) throws IOException {
        this.flagTextContent();
        this.m_escaper.writeCData(text, this.m_writer);
    }

    public void indent(int bias) throws IOException {
        if (this.m_indent) {
            int length = this.m_indentBase + (this.getNestingDepth() + bias) * this.m_indentPerLevel;
            if (length > this.m_indentSequence.length) {
                int use = Math.max(length, this.m_indentSequence.length * 2 - this.m_indentBase);
                char[] grow = new char[use];
                System.arraycopy(this.m_indentSequence, 0, grow, 0, this.m_indentSequence.length);
                for (int i = this.m_indentSequence.length; i < use; ++i) {
                    grow[i] = grow[this.m_indentBase];
                }
                this.m_indentSequence = grow;
            }
            this.m_writer.write(this.m_indentSequence, 0, length);
        }
    }

    public void indent() throws IOException {
        this.indent(0);
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.flush();
        if (this.m_writer != null) {
            this.m_writer.close();
            this.m_writer = null;
        }
    }

    public IXMLWriter createChildWriter(String[] uris) {
        return new GenericXMLWriter(this, uris);
    }
}

