/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingHelper {
    private static final Log log = LogFactory.getLog((Class)AddressingHelper.class);

    public static boolean isReplyRedirected(MessageContext messageContext) {
        EndpointReference replyTo = messageContext.getReplyTo();
        if (replyTo == null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " isReplyRedirected: ReplyTo is null. Returning false"));
            }
            return false;
        }
        return !replyTo.hasAnonymousAddress();
    }

    public static boolean isFaultRedirected(MessageContext messageContext) {
        EndpointReference faultTo = messageContext.getFaultTo();
        if (faultTo == null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " isReplyRedirected: FaultTo is null. Returning isReplyRedirected"));
            }
            return AddressingHelper.isReplyRedirected(messageContext);
        }
        return !faultTo.hasAnonymousAddress();
    }

    public static boolean shouldSendFaultToFaultTo(MessageContext messageContext) {
        Object faultInfoForHeaders = messageContext.getProperty("FaultHeaders");
        boolean doNotSendFaultUsingFaultTo = false;
        if (faultInfoForHeaders != null) {
            String problemHeaderName = (String)((Map)faultInfoForHeaders).get("ProblemHeaderQName");
            doNotSendFaultUsingFaultTo = problemHeaderName != null && "wsa:FaultTo".equals(problemHeaderName);
        }
        return !doNotSendFaultUsingFaultTo;
    }

    public static String getAnonymousParameterValue(AxisOperation axisOperation) {
        String value = "";
        if (axisOperation != null) {
            value = Utils.getParameterValue(axisOperation.getParameter("wsawAnonymous"));
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("getAnonymousParameterValue: value: '" + value + "'"));
            }
        }
        if (value == null || "".equals(value.trim())) {
            value = "optional";
        }
        return value.trim();
    }

    public static void setAnonymousParameterValue(AxisOperation axisOperation, String value) {
        block11: {
            if (value == null) {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)"setAnonymousParameterValue: value passed in is null. return");
                }
                return;
            }
            Parameter param = axisOperation.getParameter("wsawAnonymous");
            if (param != null) {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)"setAnonymousParameterValue: Parameter already exists");
                }
                if (!param.isLocked()) {
                    if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                        log.debug((Object)("setAnonymousParameterValue: Parameter not locked. Setting value: " + value));
                    }
                    param.setValue(value);
                }
            } else {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)"setAnonymousParameterValue: Parameter does not exist");
                }
                param = new Parameter();
                param.setName("wsawAnonymous");
                param.setValue(value);
                try {
                    if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                        log.debug((Object)("setAnonymousParameterValue: Adding parameter with value: " + value));
                    }
                    axisOperation.addParameter(param);
                }
                catch (AxisFault af) {
                    if (!LoggingControl.debugLoggingAllowed || !log.isDebugEnabled()) break block11;
                    log.debug((Object)("setAnonymousParameterValue: addParameter failed: " + af.getMessage()));
                }
            }
        }
    }
}

