/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.MetaDataEntry;
import org.apache.axis2.util.ObjectStateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OperationContext
extends AbstractContext
implements Externalizable {
    private static final Log log = LogFactory.getLog((Class)OperationContext.class);
    private static final String myClassName = "OperationContext";
    private String logCorrelationIDString = "OperationContext@" + UUIDGenerator.getUUID();
    private static final long serialVersionUID = -7264782778333554350L;
    private static final int REVISION_1 = 1;
    private static final int revisionID = 1;
    private boolean isComplete;
    private String key;
    private transient AxisOperation axisOperation;
    private transient HashMap messageContexts = new HashMap();
    private transient boolean needsToBeReconciled = false;
    private transient boolean suppressWarnings = false;
    private transient MetaDataEntry metaAxisOperation = null;
    private transient MetaDataEntry metaAxisService = null;
    private transient ServiceContext metaParent = null;
    private HashMap metaMessageContextMap = null;
    private transient HashMap isolatedMessageContexts = null;
    private transient HashMap workingSet = null;

    public OperationContext() {
        super(null);
    }

    public OperationContext(AxisOperation axisOperation, ServiceContext serviceContext) {
        super(serviceContext);
        this.axisOperation = axisOperation;
        this.setParent(serviceContext);
    }

    public void addMessageContext(MessageContext msgContext) throws AxisFault {
        if (this.axisOperation != null) {
            this.axisOperation.addMessageContext(msgContext, this);
            this.touch();
        }
    }

    public void cleanup() {
        ServiceContext serv = this.getServiceContext();
        if (serv != null) {
            serv.getConfigurationContext().unregisterOperationContext(this.key);
        }
    }

    public AxisOperation getAxisOperation() {
        if (this.needsToBeReconciled && !this.suppressWarnings) {
            log.warn((Object)(this.logCorrelationIDString + ":getAxisOperation(): ****WARNING**** OperationContext.activate(configurationContext) needs to be invoked."));
        }
        return this.axisOperation;
    }

    public ConfigurationContext getConfigurationContext() {
        if (this.parent != null) {
            return ((ServiceContext)this.parent).getConfigurationContext();
        }
        return null;
    }

    public MessageContext getMessageContext(String messageLabel) throws AxisFault {
        if (this.messageContexts == null) {
            return null;
        }
        return (MessageContext)this.messageContexts.get(messageLabel);
    }

    public HashMap getMessageContexts() {
        return this.messageContexts;
    }

    public ServiceContext getServiceContext() {
        return (ServiceContext)this.parent;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean complete) {
        this.isComplete = complete;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(-7264782778333554350L);
        out.writeInt(1);
        out.writeLong(this.getLastTouchedTime());
        out.writeBoolean(this.isComplete);
        ObjectStateUtils.writeString(out, this.key, this.logCorrelationIDString + ".key");
        ObjectStateUtils.writeString(out, this.logCorrelationIDString, this.logCorrelationIDString + ".logCorrelationIDString");
        Map tmpMap = this.getProperties();
        HashMap tmpHashMap = null;
        if (tmpMap != null && !tmpMap.isEmpty()) {
            tmpHashMap = new HashMap(tmpMap);
        }
        ObjectStateUtils.writeHashMap(out, tmpHashMap, this.logCorrelationIDString + ".properties");
        String axisOpMarker = this.logCorrelationIDString + ".axisOperation";
        ObjectStateUtils.writeString(out, axisOpMarker, axisOpMarker);
        if (this.axisOperation == null) {
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
        } else {
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            this.metaAxisOperation = new MetaDataEntry(this.axisOperation.getClass().getName(), this.axisOperation.getName().toString());
            ObjectStateUtils.writeObject(out, this.metaAxisOperation, this.logCorrelationIDString + ".metaAxisOperation");
        }
        String axisServMarker = this.logCorrelationIDString + ".metaAxisService";
        ObjectStateUtils.writeString(out, axisServMarker, axisServMarker);
        AxisService axisService = this.axisOperation.getAxisService();
        if (axisService == null) {
            out.writeBoolean(ObjectStateUtils.EMPTY_OBJECT);
        } else {
            out.writeBoolean(ObjectStateUtils.ACTIVE_OBJECT);
            this.metaAxisService = new MetaDataEntry(axisService.getClass().getName(), axisService.getName());
            ObjectStateUtils.writeObject(out, this.metaAxisService, this.logCorrelationIDString + ".metaAxisService");
        }
        ServiceContext myParent = this.getServiceContext();
        ObjectStateUtils.writeObject(out, myParent, this.logCorrelationIDString + ".parent ServiceContext");
        HashMap<String, MessageContext> tmpMsgCtxMap = null;
        if (this.messageContexts != null && !this.messageContexts.isEmpty()) {
            this.workingSet = new HashMap();
            tmpMsgCtxMap = new HashMap<String, MessageContext>();
            Set keySet = this.messageContexts.keySet();
            Iterator itKeys = keySet.iterator();
            while (itKeys.hasNext()) {
                String idIsol;
                MessageContext valueIsolated;
                String keyObj = (String)itKeys.next();
                MessageContext value = (MessageContext)this.messageContexts.get(keyObj);
                boolean addToWorkingSet = true;
                if (this.isolatedMessageContexts != null && !this.isolatedMessageContexts.isEmpty() && (valueIsolated = (MessageContext)this.isolatedMessageContexts.get(keyObj)) != null && (idIsol = valueIsolated.getMessageID()) != null && idIsol.equals(value.getMessageID())) {
                    addToWorkingSet = false;
                }
                if (!addToWorkingSet) continue;
                this.workingSet.put(keyObj, value);
            }
            Set keySet2 = this.workingSet.keySet();
            Iterator itKeys2 = keySet2.iterator();
            while (itKeys2.hasNext()) {
                String keyObj2 = (String)itKeys2.next();
                MessageContext value2 = (MessageContext)this.workingSet.get(keyObj2);
                MessageContext modifiedValue2 = value2.extractCopyMessageContext();
                tmpMsgCtxMap.put(keyObj2, modifiedValue2);
                log.trace((Object)(this.logCorrelationIDString + ":writeExternal():  getting working set entry  key [" + keyObj2 + "]   message context ID[" + modifiedValue2.getMessageID() + "]"));
            }
        }
        ObjectStateUtils.writeHashMap(out, tmpMsgCtxMap, this.logCorrelationIDString + ".messageContexts working set");
        ObjectStateUtils.writeHashMap(out, this.metaMessageContextMap, this.logCorrelationIDString + ".metaMessageContextMap metadata table");
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.needsToBeReconciled = true;
        log.trace((Object)("OperationContext:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  "));
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != -7264782778333554350L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 1) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        long time = in.readLong();
        this.setLastTouchedTime(time);
        this.isComplete = in.readBoolean();
        this.key = ObjectStateUtils.readString(in, "OperationContext.key");
        this.logCorrelationIDString = ObjectStateUtils.readString(in, "OperationContext.logCorrelationIDString");
        log.trace((Object)("OperationContext:readExternal():  reading input stream for [" + this.logCorrelationIDString + "]  "));
        HashMap tmpHashMap = ObjectStateUtils.readHashMap(in, "OperationContext.properties");
        this.properties = new HashMap();
        if (tmpHashMap != null) {
            this.setProperties(tmpHashMap);
        }
        this.axisOperation = null;
        ObjectStateUtils.readString(in, "OperationContext.axisOperation");
        boolean metaAxisOperationIsActive = in.readBoolean();
        this.metaAxisOperation = metaAxisOperationIsActive == ObjectStateUtils.ACTIVE_OBJECT ? (MetaDataEntry)ObjectStateUtils.readObject(in, "OperationContext.metaAxisOperation") : null;
        ObjectStateUtils.readString(in, "OperationContext.axisService");
        boolean metaAxisServiceIsActive = in.readBoolean();
        this.metaAxisService = metaAxisServiceIsActive == ObjectStateUtils.ACTIVE_OBJECT ? (MetaDataEntry)ObjectStateUtils.readObject(in, "OperationContext.metaAxisService") : null;
        this.metaParent = (ServiceContext)ObjectStateUtils.readObject(in, "OperationContext.parent ServiceContext");
        this.messageContexts = new HashMap();
        this.workingSet = ObjectStateUtils.readHashMap(in, this.logCorrelationIDString + ".messageContexts working set");
        this.metaMessageContextMap = ObjectStateUtils.readHashMap(in, this.logCorrelationIDString + ".metaMessageContextMap metadata table");
    }

    public void activate(ConfigurationContext cc) {
        boolean registrationSuceeded;
        if (!this.needsToBeReconciled) {
            return;
        }
        AxisConfiguration axisConfig = cc.getAxisConfiguration();
        AxisService axisService = null;
        if (this.metaAxisService != null) {
            axisService = ObjectStateUtils.findService(axisConfig, this.metaAxisService.getClassName(), this.metaAxisService.getQNameAsString());
        }
        if (this.metaAxisOperation != null) {
            this.axisOperation = axisService != null ? ObjectStateUtils.findOperation(axisService, this.metaAxisOperation.getClassName(), this.metaAxisOperation.getQName()) : ObjectStateUtils.findOperation(axisConfig, this.metaAxisOperation.getClassName(), this.metaAxisOperation.getQName());
        }
        if (this.metaParent != null) {
            OperationContext existingOC;
            String groupName = this.metaParent.getGroupName();
            String serviceName = this.metaParent.getName();
            ServiceContext existingSC = null;
            ServiceGroupContext sgc = cc.getServiceGroupContext(groupName);
            if (sgc != null) {
                existingSC = sgc.findServiceContext(serviceName);
            }
            if (existingSC == null && (existingOC = cc.findOperationContext(this.getOperationName(), serviceName, groupName)) != null) {
                existingSC = (ServiceContext)existingOC.getParent();
            }
            if (existingSC == null) {
                this.metaParent.activate(cc);
                this.setParent(this.metaParent);
            } else {
                this.setParent(existingSC);
                this.metaParent.putContextProperties(existingSC, true);
            }
        } else {
            this.setParent(this.metaParent);
        }
        ServiceContext serv = this.getServiceContext();
        ConfigurationContext activeCC = serv != null ? serv.getConfigurationContext() : cc;
        if (this.key != null && !(registrationSuceeded = activeCC.registerOperationContext(this.key, this))) {
            log.trace((Object)(this.logCorrelationIDString + ":activate():  OperationContext key [" + this.key + "] already exists in ConfigurationContext map.  This OperationContext [" + this.toString() + "] was not added to the table."));
        }
        if (this.workingSet != null && !this.workingSet.isEmpty()) {
            Set keySet = this.workingSet.keySet();
            Iterator itKeys = keySet.iterator();
            while (itKeys.hasNext()) {
                String keyObj = (String)itKeys.next();
                MessageContext value = (MessageContext)this.workingSet.get(keyObj);
                if (value != null) {
                    log.trace((Object)(this.logCorrelationIDString + ":activate():  key [" + keyObj + "]  message id [" + value.getMessageID() + "]"));
                    this.suppressWarnings = true;
                    value.activateWithOperationContext(this);
                    this.suppressWarnings = false;
                    if (this.messageContexts == null) {
                        this.messageContexts = new HashMap();
                    }
                }
                this.messageContexts.put(keyObj, value);
            }
        }
        this.needsToBeReconciled = false;
    }

    public void isolateMessageContext(MessageContext mc) {
        if (mc == null) {
            return;
        }
        if (this.messageContexts == null || this.messageContexts.isEmpty()) {
            return;
        }
        String messageID = mc.getMessageID();
        if (messageID == null) {
            return;
        }
        Iterator it = this.messageContexts.keySet().iterator();
        while (it.hasNext()) {
            String valueID;
            Object keyObj = it.next();
            MessageContext value = (MessageContext)this.messageContexts.get(keyObj);
            if (value == null || (valueID = value.getMessageID()) == null || !valueID.equals(messageID)) continue;
            if (this.metaMessageContextMap == null) {
                this.metaMessageContextMap = new HashMap();
            }
            MetaDataEntry metaData = new MetaDataEntry(value.getClass().getName(), value.getMessageID(), keyObj.toString());
            this.metaMessageContextMap.put(keyObj, metaData);
            if (this.isolatedMessageContexts == null) {
                this.isolatedMessageContexts = new HashMap();
            }
            this.isolatedMessageContexts.put(keyObj, value);
            log.trace((Object)(this.logCorrelationIDString + ":isolateMessageContext():  set up message context id[" + valueID + "]  with key [" + keyObj.toString() + "] from messageContexts table to prepare for serialization."));
            break;
        }
    }

    public void restoreMessageContext(MessageContext msg) {
        block6: {
            String msgID;
            block7: {
                if (this.needsToBeReconciled) {
                    log.trace((Object)(this.logCorrelationIDString + ":restoreMessageContext(): *** WARNING : need to invoke activate() prior to restoring the MessageContext to the list."));
                    return;
                }
                if (msg == null) {
                    return;
                }
                msgID = msg.getMessageID();
                if (msgID == null) {
                    log.trace((Object)(this.logCorrelationIDString + ":restoreMessageContext(): *** WARNING : MessageContext does not have a message ID."));
                    return;
                }
                if (this.metaMessageContextMap == null || this.metaMessageContextMap.isEmpty()) break block7;
                Iterator itMeta = this.metaMessageContextMap.keySet().iterator();
                while (itMeta.hasNext()) {
                    String valueM_ID;
                    String keyM = (String)itMeta.next();
                    MetaDataEntry valueM = (MetaDataEntry)this.metaMessageContextMap.get(keyM);
                    if (valueM == null || !msgID.equals(valueM_ID = valueM.getQNameAsString())) continue;
                    String label = valueM.getExtraName();
                    if (this.messageContexts == null) {
                        this.messageContexts = new HashMap();
                    }
                    this.messageContexts.put(label, msg);
                    this.metaMessageContextMap.remove(keyM);
                    log.trace((Object)(this.logCorrelationIDString + ":restoreMessageContext():  restored   label [" + label + "]    message ID [" + msg.getMessageID() + "]"));
                    break block6;
                }
                break block6;
            }
            if (this.messageContexts == null || this.messageContexts.isEmpty()) break block6;
            Iterator itList = this.messageContexts.keySet().iterator();
            while (itList.hasNext()) {
                String valueID;
                String key = (String)itList.next();
                MessageContext value = (MessageContext)this.messageContexts.get(key);
                if (value == null || !msgID.equals(valueID = value.getMessageID())) continue;
                this.messageContexts.put(key, msg);
            }
        }
    }

    public String getOperationName() {
        QName qname;
        String opName = null;
        if (this.axisOperation != null && (qname = this.axisOperation.getName()) != null) {
            opName = qname.getLocalPart();
        }
        return opName;
    }

    public String getServiceName() {
        String srvName = null;
        ServiceContext sc = (ServiceContext)this.getParent();
        if (sc == null) {
            sc = this.metaParent;
        }
        if (sc != null) {
            srvName = sc.getName();
        }
        return srvName;
    }

    public String getServiceGroupName() {
        String srvGroupName = null;
        ServiceContext sc = (ServiceContext)this.getParent();
        if (sc == null) {
            sc = this.metaParent;
        }
        if (sc != null) {
            srvGroupName = sc.getGroupName();
        }
        return srvGroupName;
    }

    public boolean isEquivalent(OperationContext ctx) {
        if (this.isComplete != ctx.isComplete()) {
            return false;
        }
        return this.axisOperation.equals(ctx.getAxisOperation());
    }

    public String getLogCorrelationIDString() {
        return this.logCorrelationIDString;
    }

    public ConfigurationContext getRootContext() {
        return this.getConfigurationContext();
    }
}

