/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class ProxyConfiguration {
    protected String proxyHost;
    protected String nonProxyHosts;
    protected int proxyPort = -1;
    protected String proxyUser;
    protected String proxyPassword;
    protected static final String HTTP_PROXY_HOST = "http.proxyHost";
    protected static final String HTTP_PROXY_PORT = "http.proxyPort";
    protected static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    protected static final String ATTR_PROXY = "Proxy";
    protected static final String PROXY_HOST_ELEMENT = "ProxyHost";
    protected static final String PROXY_PORT_ELEMENT = "ProxyPort";
    protected static final String PROXY_USER_ELEMENT = "ProxyUser";
    protected static final String PROXY_PASSWORD_ELEMENT = "ProxyPassword";

    public void configure(MessageContext messageContext, HttpClient httpClient, HostConfiguration config) throws AxisFault {
        String port;
        String host;
        HttpTransportProperties.ProxyProperties proxyProperties;
        UsernamePasswordCredentials proxyCred = null;
        Parameter param = messageContext.getConfigurationContext().getAxisConfiguration().getParameter(ATTR_PROXY);
        if (param != null) {
            int domainIndex;
            OMElement configurationEle = param.getParameterElement().getFirstElement();
            if (configurationEle == null) {
                throw new AxisFault(ProxyConfiguration.class.getName() + " Configuration element is missing");
            }
            OMElement proxyHostEle = configurationEle.getFirstChildWithName(new QName(PROXY_HOST_ELEMENT));
            OMElement proxyPortEle = configurationEle.getFirstChildWithName(new QName(PROXY_PORT_ELEMENT));
            OMElement proxyUserEle = configurationEle.getFirstChildWithName(new QName(PROXY_USER_ELEMENT));
            OMElement proxyPasswordEle = configurationEle.getFirstChildWithName(new QName(PROXY_PASSWORD_ELEMENT));
            if (proxyHostEle == null) {
                throw new AxisFault(ProxyConfiguration.class.getName() + " ProxyHost element is missing");
            }
            String text = proxyHostEle.getText();
            if (text == null) {
                throw new AxisFault(ProxyConfiguration.class.getName() + " ProxyHost's value is missing");
            }
            this.setProxyHost(text);
            if (proxyPortEle != null) {
                this.setProxyPort(Integer.parseInt(proxyPortEle.getText()));
            }
            if (proxyUserEle != null) {
                this.setProxyUser(proxyUserEle.getText());
            }
            if (proxyPasswordEle != null) {
                this.setProxyPassword(proxyPasswordEle.getText());
            }
            proxyCred = this.getProxyUser() == null && this.getProxyUser() == null ? new UsernamePasswordCredentials("", "") : new UsernamePasswordCredentials(this.getProxyUser(), this.getProxyPassword());
            if (this.getProxyUser() != null && (domainIndex = this.getProxyUser().indexOf("\\")) > 0) {
                String domain = this.getProxyUser().substring(0, domainIndex);
                if (this.getProxyUser().length() > domainIndex + 1) {
                    String user = this.getProxyUser().substring(domainIndex + 1);
                    proxyCred = new NTCredentials(user, this.getProxyPassword(), this.getProxyHost(), domain);
                }
            }
        }
        if ((proxyProperties = (HttpTransportProperties.ProxyProperties)messageContext.getProperty("PROXY")) != null) {
            host = proxyProperties.getProxyHostName();
            if (host == null || host.length() == 0) {
                throw new AxisFault(ProxyConfiguration.class.getName() + " Proxy host is not available. Host is a MUST parameter");
            }
            this.setProxyHost(host);
            this.setProxyPort(proxyProperties.getProxyPort());
            String userName = proxyProperties.getUserName();
            String password = proxyProperties.getPassWord();
            String domain = proxyProperties.getDomain();
            proxyCred = userName == null && password == null ? new UsernamePasswordCredentials("", "") : new UsernamePasswordCredentials(userName, password);
            if (userName != null && password != null && domain != null) {
                proxyCred = new NTCredentials(userName, password, host, domain);
            }
        }
        if ((host = System.getProperty(HTTP_PROXY_HOST)) != null) {
            this.setProxyHost(host);
            proxyCred = new UsernamePasswordCredentials("", "");
        }
        if ((port = System.getProperty(HTTP_PROXY_PORT)) != null) {
            this.setProxyPort(Integer.parseInt(port));
        }
        if (proxyCred == null) {
            throw new AxisFault(ProxyConfiguration.class.getName() + " Minimum proxy credentials are not set");
        }
        httpClient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)proxyCred);
        config.setProxy(this.getProxyHost(), this.getProxyPort());
    }

    public static boolean isProxyEnabled(MessageContext messageContext, URL targetURL) throws AxisFault {
        boolean state = false;
        Parameter param = messageContext.getConfigurationContext().getAxisConfiguration().getParameter(ATTR_PROXY);
        Object obj = messageContext.getProperty("PROXY");
        String sp = System.getProperty(HTTP_PROXY_HOST);
        if (param != null || obj != null || sp != null) {
            state = true;
        }
        boolean isNonProxyHost = ProxyConfiguration.validateNonProxyHosts(targetURL.getHost());
        return state && !isNonProxyHost;
    }

    private static boolean validateNonProxyHosts(String targetHost) {
        String nonProxyHosts = System.getProperty(HTTP_NON_PROXY_HOSTS);
        if (nonProxyHosts == null) {
            return false;
        }
        String[] nonProxyHostsArray = nonProxyHosts.split("\\|");
        if (nonProxyHostsArray.length == 1) {
            return targetHost.matches(nonProxyHosts);
        }
        boolean pass = false;
        for (int i = 0; i < nonProxyHostsArray.length; ++i) {
            String a = nonProxyHostsArray[i];
            if (!targetHost.matches(a)) continue;
            pass = true;
            break;
        }
        return pass;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }
}

