using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace SlothLib.IO
{
	/// <summary>
	/// xdoc2txtgĊet@Ce擾
	/// [2006-12-04][rui] .txt̓ǂݍ݂\ɂ悤ɏC
	/// [2006-11-12][ohshima] 쐬
	/// </summary>
	public class Xdoc2txtReader : AbstractContentReader
	{

		// xdoc2txtΉt@C
		//	.rtf	b`eLXg
		//	.doc	WORD ver5.0/95/97/2000(*1)
		//	.xls	Excel ver5.0/95/97/2000(*1)
		//	.ppt	PowerPoint 97/2000(*1)
		//	.jaw/jtw ꑾY ver5
		//	.jbw/juw ꑾY ver6
		//	.jfw/jvw ꑾY ver7
		//	.jtd/jtt ꑾY ver8/9/10/11/12
		//	.oas/oa2/oa3	OASYS/Win
		//	.bun	V/5/6
		//	.wj2/wj3/wk3/wk4/123	Lotus 123 
		//	.wri	Windows3.1 Write 
		//	.pdf	Adobe PDF
		//	.mht	
		//	.html	HTML
		//	.txt	TEXT


		//xdoc2txt.exẽpX
		private string xdoc2txtExePath = null;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="xdoc2txtExePath">Xdoc2txt.exẽpX</param>
		public Xdoc2txtReader(string xdoc2txtExePath)
			: base(
				".rtf", ".doc", ".xls", ".ppt",
				".jaw", ".jtw", ".jbw", ".juw", ".jfw", ".jvw", ".jtd", ".jtt",
				".oas", ".oa2", ".oa3", ".bun",
				".wj2", ".wj3", ".wk3", ".wk4", ".123",
				".wri", ".pdf", ".mht", ".html", 
				".txt")
		{
			if (File.Exists(xdoc2txtExePath))
			{
				this.xdoc2txtExePath = xdoc2txtExePath;
			}
			else
			{
				throw new FileNotFoundException("w肳ꂽxdoc2txt.exe܂ł", xdoc2txtExePath);
			}
		}


		/// <summary>
		/// t@CeLXg𒊏oB
		/// ΉĂ邩ǂReadablepB
		/// </summary>
		/// <param name="filePath">t@C̃pX</param>
		/// <returns>oꂽe</returns>
		protected override string Process(string filePath)
		{
			using (System.Diagnostics.Process p = new System.Diagnostics.Process())
			{
				try
				{
					// EChE\ȂB
					p.StartInfo.CreateNoWindow = true;
					// Ȃ񂩁B
					p.StartInfo.UseShellExecute = false;
					// Wo͂擾
					p.StartInfo.RedirectStandardOutput = true;
					// st@C
					p.StartInfo.FileName = xdoc2txtExePath;
					// 
					p.StartInfo.Arguments = @"-n -o=1 """ + filePath + @"""";

					// sB
					p.Start();
					// Wo͂̓ǂݎ
					string output = p.StandardOutput.ReadToEnd();
					// I҂B
					p.WaitForExit();

					// IR[hmF
					int ec = p.ExitCode;
					p.Close();
					if (ec != 0)
					{
						throw new ApplicationException("xdoc2txtG[Ԃ܂B");
					}

					// ʂԂB
					return output;
				}
				catch
				{
					p.Kill();
					throw;
				}
			}
		}


	}
}
