using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Matrix {
    /// <summary>
    /// IMatrix炳ɁAZ@\NXB
    /// </summary>
    /// <remarks>
    /// 
    /// <newpara>[2007-05-09][kabutoya]쐬</newpara>
    /// <newpara>[2007-11-12][kabutoya]C</newpara>
    /// </remarks>
    public abstract class AbstractMatrix : IMatrix
    {
        #region Iy[^

		/// <summary>
		/// s񓯎m̉ZIy[^[
		/// </summary>
		/// <param name="matrix1"></param>
		/// <param name="matrix2"></param>
		/// <returns></returns>
        public static AbstractMatrix operator +(AbstractMatrix matrix1, AbstractMatrix matrix2)
        {
            return (AbstractMatrix)MatrixOperator.Add(matrix1, matrix2);
        }

		/// <summary>
		/// s񓯎m̌ZIy[^[
		/// </summary>
		/// <param name="matrix1"></param>
		/// <param name="matrix2"></param>
		/// <returns></returns>
        public static AbstractMatrix operator -(AbstractMatrix matrix1, AbstractMatrix matrix2)
        {
            return (AbstractMatrix)MatrixOperator.Subtract(matrix1, matrix2);
        }

		/// <summary>
		/// s̕Iy[^[
		/// </summary>
		/// <param name="matrix"></param>
		/// <returns></returns>
        public static AbstractMatrix operator -(AbstractMatrix matrix)
        {
            return (AbstractMatrix)MatrixOperator.Negate(matrix);
        }

		/// <summary>
		/// s̒萔{Iy[^[
		/// </summary>
		/// <param name="schalar"></param>
		/// <param name="matrix"></param>
		/// <returns></returns>
        public static AbstractMatrix operator *(double schalar, AbstractMatrix matrix)
        {
            return (AbstractMatrix)MatrixOperator.Multiply(schalar, matrix);
        }

        /// <summary>
        /// w肵 2 ̍s̒lꂩǂ𔻒f܂B
        /// </summary>
        /// <param name="matrix1"></param>
        /// <param name="matrix2"></param>
        /// <returns>ł trueAȂ falseB</returns>
        public static bool operator ==(AbstractMatrix matrix1, IMatrix matrix2)
        {
            return MatrixOperator.Equals(matrix1, matrix2);
        }

        /// <summary>
        /// w肵 2 ̍s̒lꂩǂ𔻒f܂B
        /// </summary>
        /// <param name="matrix1"></param>
        /// <param name="matrix2"></param>
        /// <returns>ł falseAȂ trueB</returns>
        public static bool operator !=(AbstractMatrix matrix1, IMatrix matrix2)
        {
            return !MatrixOperator.Equals(matrix1, matrix2);
        }

        #endregion

        #region IMatrix o

		/// <summary>
		/// sdouble[,]^ɕϊ
		/// </summary>
		/// <returns></returns>
        public abstract double[,] GetPlainMatrix();

		/// <summary>
		/// sɃANZX
		/// </summary>
		/// <param name="row"></param>
		/// <param name="column"></param>
		/// <returns></returns>
        public abstract double this[int row, int column]
        {
            get;
            set;
        }

		/// <summary>
		/// 񐔂擾
		/// </summary>
        public abstract int RowCount
        {
            get;
        }

		/// <summary>
		/// s擾
		/// </summary>
        public abstract int ColumnCount
        {
            get;
        }

		/// <summary>
		/// 擾
		/// </summary>
		/// <returns></returns>
        public abstract object Clone();

        #endregion

        /// <summary>
        /// ̃xNgƁAw肵 SlothLib.LinearAlgebra.IMatrix IuWFNg̒lꂩǂ𔻒f܂B
        /// </summary>
        /// <param name="value">SlothLib.LinearAlgebra.IMatrixB</param>
        /// <returns></returns>
        public abstract bool Equals(IMatrix value);

        /// <summary>
        /// ̃xNgƁAw肵 System.Object IuWFNg̒lꂩǂ𔻒f܂B
        /// </summary>
        /// <param name="obj">System.ObjectB</param>
        /// <returns></returns>
        public override bool Equals(object obj)
        {
            IMatrix other = obj as IMatrix;

            if (ReferenceEquals(other, null))
            {
                return false;
            }

            return this.Equals(other);
        }

        /// <summary>
        /// ̍s̃nbVR[hԂ܂B
        /// </summary>
        /// <returns></returns>
        public override int GetHashCode()
        {
            int hashCode = this.RowCount ^ this.ColumnCount;

            for (int r = 0; r < this.RowCount; r++)
            {
                for (int c = 0; c < this.ColumnCount; c++)
                {
                    hashCode = hashCode ^ this[r, c].GetHashCode();
                }
            }

            return hashCode;
        }
    }
}