using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Matrix
{
    /// <summary>
    /// MaxNorm̏C
    /// d݂0łȂvfɑ΂MINȏ̏d݂ۏ؂
    /// Value = (MIN + (MAX - MIN) * MaxNorm(Value))
    /// ݒłMIN=0.5CMAX=1.0
    /// </summary>
    public class AugNormMatrix : BasicMatrix
    {
        private const double MIN = 0.5;
        private const double MAX = 1.0;

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="matrix"></param>
        public AugNormMatrix(IMatrix matrix)
            : base(matrix.RowCount, matrix.ColumnCount)
        {
            double absMax = MatrixOperator.GetMaxNorm(matrix);

            for (int i = 0; i < matrix.RowCount; i++)
            {
                for (int j = 0; j < matrix.ColumnCount; j++)
                {
                    if (absMax != 0.0)
                    {
                        this[i, j] = MIN + (MAX - MIN) * matrix[i, j] / absMax;
                    }
                    else
                    {
                        this[i, j] = default(double);
                    }
                }

            }
        }
    }
}
