using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Matrix
{
    /// <summary>
    /// s̋ts
    /// Value = 1.0 / Value
    /// C0̗vfɑ΂Ă͋t͎Ȃ
    /// </summary>
    public class InverseMatrix : BasicMatrix
    {
        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="matrix"></param>
        public InverseMatrix(IMatrix matrix)
            : base(matrix.RowCount, matrix.ColumnCount)
        {
            for (int i = 0; i < matrix.RowCount; i++)
            {
                for (int j = 0; j < matrix.ColumnCount; j++)
                {
                    if (matrix[i, j] != 0.0)
                    {
                        this[i, j] = 1.0 / matrix[i, j];
                    }
                    else
                    {
                        this[i, j] = 0.0;
                    }
                }
            }
        }
    }
}
