using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Matrix
{
	/// <summary>
	/// sɑ΂e퉉Z public static \bhB
	/// </summary>
	/// <remarks>
	/// 
	/// <newpara>[2007-05-09][kabutoya]쐬</newpara>
    /// <newpara>[2007-07-14][kabutoya]ǉ</newpara>
	/// </remarks>
	public class MatrixOperator
    {
        #region matrix -> scalar ^Z

        #region 0ȏ̍ővf

        /// <summary>
        /// sɂvf̂A0ȏ̒lvf̍ől擾
        /// </summary>
        /// <param name="matrix"></param>
        /// <returns>s̗vf̍ől</returns>
        private static double GetMaxElement(IMatrix matrix)
        {
            double max = default(double);

            for (int i = 0; i < matrix.RowCount; i++)
            {
                for (int j = 0; j < matrix.ColumnCount; j++)
                {
                    if (max < matrix[i, j])
                    {
                        max = matrix[i, j];
                    }
                }
            }

            return max;
        }

        #endregion

        #region 0ȉ̍ŏvf

        /// <summary>
        ///  sɂvf̂A0ȉ̒lvf̍ŏl擾
        /// </summary>
        /// <param name="matrix"></param>
        /// <returns></returns>
        private static double GetMinElement(IMatrix matrix)
        {
            double min = default(double);

            for (int i = 0; i < matrix.RowCount; i++)
            {
                for (int j = 0; j < matrix.ColumnCount; j++)
                {
                    if (min > matrix[i, j])
                    {
                        min = matrix[i, j];
                    }
                }
            }

            return min;
        }

        #endregion

        #region Βl̍ől

        /// <summary>
        /// s̗vf̂ΒlőƂȂ̂̒lԂ
        /// </summary>
        /// <param name="matrix"></param>
        /// <returns></returns>
        public static double GetMaxNorm(IMatrix matrix)
        {
            double absMax = default(double);

            for (int i = 0; i < matrix.RowCount; i++)
            {
                for (int j = 0; j < matrix.ColumnCount; j++)
                {
                    if (absMax < Math.Abs(matrix[i, j]))
                    {
                        absMax = Math.Abs(matrix[i, j]);
                    }
                }
            }

            return absMax;
        }

        #endregion

        #region Svf̑a

        /// <summary>
        /// s̑Svf̒l̑aԂ
        /// </summary>
        /// <param name="matrix"></param>
        /// <returns></returns>
        public static double GetAllElementSum(IMatrix matrix)
        {
            double sum = default(double);

            for (int i = 0; i < matrix.RowCount; i++)
            {
                for (int j = 0; j < matrix.ColumnCount; j++)
                {
                    sum += matrix[i, j];
                }
            }

            return sum;
        }

        #endregion

        #endregion

        #region matrix * matrix -> scalar ^Z

        #region Equals

        /// <summary>
        /// w肵 2  SlothLib.LinearAlgebra.IMatrix IuWFNg̒lꂩǂ𔻒f܂B
        /// </summary>
        /// <param name="matrix1">rΏۂ̑ 1 SlothLib.LinearAlgebra.IMatrixB</param>
        /// <param name="matrix2">rΏۂ̑ 2 SlothLib.LinearAlgebra.IMatrixB</param>
        /// <returns></returns>
        public static bool Equals(IMatrix matrix1, IMatrix matrix2)
        {
            if (ReferenceEquals(matrix1, matrix2))
            {
                return true;
            }

            if (ReferenceEquals(matrix1, null) || ReferenceEquals(matrix2, null))
            {
                return false;
            }

            return matrix1.Equals(matrix2);
        }

        #endregion

        #endregion

        #region matrix * matrix -> matrix ^Z

        #region a

        /// <summary>
        /// s̉Z
        /// </summary>
        /// <param name="matrix1"></param>
        /// <param name="matrix2"></param>
        /// <returns></returns>
        public static IMatrix Add(IMatrix matrix1, IMatrix matrix2)
		{
			if ((matrix1.RowCount != matrix2.RowCount) || (matrix1.ColumnCount != matrix2.ColumnCount))
			{
				// _ł̓G[𓊂ďI
				throw new ArgumentException("sƉEsƂōsyї񐔂v܂");
			}

			IMatrix resultMatrix = (IMatrix)matrix1.Clone();

			for (int i = 0; i < resultMatrix.RowCount; i++)
			{
				for (int j = 0; j < resultMatrix.ColumnCount; j++)
				{
					resultMatrix[i, j] += matrix2[i, j];
				}
			}

			return resultMatrix;
		}

		#endregion

		#region 

		/// <summary>
		/// šZ
		/// </summary>
		/// <param name="matrix1"></param>
		/// <param name="matrix2"></param>
		/// <returns></returns>
		public static IMatrix Subtract(IMatrix matrix1, IMatrix matrix2)
		{
			if ((matrix1.RowCount != matrix2.RowCount) || (matrix1.ColumnCount != matrix2.ColumnCount))
			{
				// _ł̓G[𓊂ďI
				throw new ArgumentException("sƉEsƂōsyї񐔂v܂");
			}

			IMatrix resultMatrix = (IMatrix)matrix1.Clone();

			for (int i = 0; i < resultMatrix.RowCount; i++)
			{
				for (int j = 0; j < resultMatrix.ColumnCount; j++)
				{
					resultMatrix[i, j] -= matrix2[i, j];
				}
			}

			return resultMatrix;
		}

		#endregion

		#endregion

        #region matrix -> matrix ^Z

        #region 

        /// <summary>
		/// s̕
		/// </summary>
		/// <param name="matrix"></param>
		/// <returns></returns>
		public static IMatrix Negate(IMatrix matrix)
		{
			IMatrix resultMatrix = (IMatrix)matrix.Clone();

			for (int i = 0; i < resultMatrix.RowCount; i++)
			{
				for (int j = 0; j < resultMatrix.ColumnCount; j++)
				{
					resultMatrix[i, j] = -matrix[i, j];
				}
			}

			return resultMatrix;
		}

		#endregion

		#endregion

		#region scalar * matrix -> matrix ^Z

		#region 萔s

		/// <summary>
		/// s̒萔{
		/// </summary>
		/// <param name="scalar"></param>
		/// <param name="matrix"></param>
		/// <returns></returns>
		public static IMatrix Multiply(double scalar, IMatrix matrix)
		{
			IMatrix resultMatrix = (IMatrix)matrix.Clone();

			for (int i = 0; i < resultMatrix.RowCount; i++)
			{
				for (int j = 0; j < resultMatrix.ColumnCount; j++)
				{
					resultMatrix[i, j] = scalar * matrix[i, j];
				}
			}

			return resultMatrix;
		}

		#endregion

		#endregion
	}
}
