﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// ベクトル群の加算結果を返すクラス
	/// </summary>
	public class AddVector<T> : BasicVector<T>
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vectors"></param>
		public AddVector(IEnumerable<IVector<T>> vectors)
		{
			Calculate(vectors);
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vectors"></param>
		public AddVector(params IVector<T>[] vectors)
		{
			Calculate(vectors);
		}

		/// <summary>
		/// ベクトルの加算を行う
		/// </summary>
		private void Calculate(IEnumerable<IVector<T>> vectors)
		{
			foreach (IVector<T> vector in vectors)
			{
				foreach (T key in vector.Keys)
				{
					if (this.ContainsKey(key))
						this[key] += vector[key];
					else
						this[key] = vector[key];
				}
			}
		}
	}
}
