using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// xNgɑ΂e퉉Z public static \bhB
	/// </summary>
	/// <remarks>
	/// 
	/// <newpara>[2007-04-25][ohshima]쐬</newpara>
	/// <newpara>[2007-05-08][shirasuna]</newpara>
	/// </remarks>
	public class VectorOperator<T>
	{
		# region vertor -> scalar ^Z

		#region p-m

		/// <summary>
		/// xNg̑SĂ̗vfp悵̘̂aA1/p悵lԂB
		/// </summary>
		/// <param name="vector">vZΏۂ̃xNg</param>
		/// <param name="p">p[^B1ȏłȂ΂ȂȂB</param>
		/// <returns></returns>

		public static double GetPNorm(IVector<T> vector, double p)
		{
			double d = 0.0;

			foreach (T key in vector.Keys)
			{
				d += Math.Pow(vector[key], p);
			}

			return Math.Pow(d, 1/p);
		}

		#endregion

		#region [NbhiPj

		/// <summary>
		/// _̃[NbhvZB
		/// </summary>
		/// <param name="vector"></param>
		/// <returns></returns>
		public static double GetEuclideanDistance(IVector<T> vector)
		{
			double d = 0.0;

			foreach (T key in vector.Keys)
			{
				d = d + Math.Pow(vector[key], 2.0);
			}
			return Math.Sqrt(d);
		}

		#endregion

		#region 0ȏ̍ővf

		/// <summary>
		/// xNgɂvf̂A0ȏ̍ővf̂ǂꂩP擾
		/// </summary>
		private static T GetMaxElementKey(IVector<T> vector)
		{
			double max = 0;
			T maxkey = default(T);

			foreach (T key in vector.Keys)
			{
				if (max < vector[key])
				{
					max = vector[key];
					maxkey = key;
				}
			}

			return maxkey;
		}

		/// <summary>
		/// xNgɂvf̂A0ȏ̒lvf̍ől擾B
		/// </summary>
		public static double GetMaxElement(IVector<T> vector)
		{
			return vector[GetMaxElementKey(vector)];
		}

		#endregion

		#region 0ȉ̍ŏvf

		/// <summary>
		/// xNgɂvf̂A0ȉ̍ŏvf̂ǂꂩP擾
		/// </summary>
		public static T GetMinElementKey(IVector<T> vector)
		{
			double min = 0;
			T minkey = default(T);

			foreach (T key in vector.Keys)
			{
				if (min > vector[key])
				{
					min = vector[key];
					minkey = key;
				}
			}

			return minkey;
		}

		/// <summary>
		/// xNgɂvf̂A0ȉ̒lvf̍ŏl擾B
		/// </summary>
		public static double GetMinElement(IVector<T> vector)
		{
			return vector[GetMinElementKey(vector)];
		}

		#endregion

		#region Βl̍ővf

		/// <summary>
		/// Βl̍őlvf̂PԂ
		/// </summary>
		private static T GetMaxAbsElementKey(IVector<T> vector)
		{
			double absmax = 0;
			T absmaxkey = default(T);

			foreach (T key in vector.Keys)
			{
				if (absmax < Math.Abs(vector[key]))
				{
					absmax = Math.Abs(vector[key]);
					absmaxkey = key;
				}
			}

			return absmaxkey;
		}

		/// <summary>
		/// MaxNormԂB
		/// ̓Iɂ́AΒl̍őlԂ
		/// </summary>

		public static double GetMaxNorm(IVector<T> vector)
		{
			return vector[GetMaxAbsElementKey(vector)];
		}

		#endregion

		#region Svf̑a

		/// <summary>
		/// xNg̑Sl̑aԂ
		/// </summary>
		public static double GetAllElementSum(IVector<T> vector)
		{
			double sum = 0;

			foreach (T key in vector.Keys)
			{
				sum += vector[key];
			}

			return sum;
		}

		#endregion

		# endregion

		# region vector * vector -> scalar ^Z

		#region [Nbhi񍀁j

		/// <summary>
		/// 2̃xNgԂ̃[NbhvZB
		/// </summary>
		/// <param name="vector1"></param>
		/// <param name="vector2"></param>
		/// <returns></returns>
		public static double GetEuclideanDistance(IVector<T> vector1, IVector<T> vector2)
		{
			IVector<T> sub = Subtract(vector1, vector2);

			return GetEuclideanDistance(sub);
		}

		#endregion

		#region }nb^

		/// <summary>
		/// }nb^iiqjԂB
		/// Ȃ킿Aevf̍̐Βl̑aB
		/// </summary>

		public static double GetManhattanDistance(IVector<T> vector1, IVector<T> vector2)
		{
			double d = 0.0;
			IVector<T> sub = Subtract(vector1, vector2);

			foreach (T key in sub.Keys)
			{
				d = d + Math.Abs(vector1[key]);
			}
			return d;
		}

		#endregion

		#region 

		/// <summary>
		/// 2̃xNgԂ̓ςvZB
		/// </summary>
		/// <param name="vector1"></param>
		/// <param name="vector2"></param>
		/// <returns></returns>
		public static double GetInnerProduct(IVector<T> vector1, IVector<T> vector2)
		{
			double ip = 0.0;

			foreach (T key in vector1.Keys)
			{
				ip += vector1[key] * vector2[key];
			}
			return ip;
		}

		#endregion

		#region RTC

		/// <summary>
		/// 2̃xNgԂ̃RTClvZB
		/// </summary>
		/// <param name="vector1"></param>
		/// <param name="vector2"></param>
		/// <returns></returns>
		public static double GetCosine(IVector<T> vector1, IVector<T> vector2)
		{
			double ip = GetInnerProduct(vector1, vector2);
			if (ip == 0)
			{
				return 0.0;
			}
			double v1Length = GetEuclideanDistance(vector1);
			double v2Length = GetEuclideanDistance(vector2);
			double cos = ip / (v1Length * v2Length);
			return cos;
		}

		#endregion

		#region JaccardW

		/// <summary>
		/// JaccardWԂB̓Iɂ́A̎ɂvZB
		/// Jaccard = (vector1,vector2) / (|vector1|^2 + |vector2|^2 - (vector1,vector2)) 
		/// </summary>

		public static double GetJaccardCoefficient(IVector<T> vector1, IVector<T> vector2)
		{
			double v1 = 0, v2 = 0;
			double inner = GetInnerProduct(vector1, vector2);

			foreach (T key in vector1.Keys)
			{
				v1 += vector1[key] * vector1[key];
			}

			foreach (T key in vector2.Keys)
			{
				v2 += vector2[key] * vector2[key];
			}

			return inner / (v1 + v2 - inner);
		}

		#endregion

		#region DiceW

		/// <summary>
		/// DiceWԂB̓Iɂ́A̎ɂvZB
		/// Dice = 2 * (vector1,vector2) / (|vector1|^2) / (|vector2|^2)
		/// </summary>

		public static double GetDiceCoefficient(IVector<T> vector1, IVector<T> vector2)
		{
			double v1 = 0, v2 = 0;

			foreach (T key in vector1.Keys)
			{
				v1 += vector1[key] * vector1[key];
			}

			foreach (T key in vector2.Keys)
			{
				v2 += vector2[key] * vector2[key];
			}

			return 2 * GetInnerProduct(vector1, vector2) / v1 / v2;
		}

		#endregion

		#endregion

		#region vector * vector -> vector ^Z

		#region a

		/// <summary>
		/// 2̃xNg̉Zs
		/// </summary>
		public static IVector<T> Add(IVector<T> vector1, IVector<T> vector2)
		{
			IVector<T> r = (IVector<T>) vector1.Clone();

			foreach (T key in vector2.Keys)
			{
				r[key] += vector2[key];
			}

			return r;
		}

		#endregion

		#region 

		/// <summary>
		/// 2̃xNǧZs
		/// </summary>
		public static IVector<T> Subtract(IVector<T> vector1, IVector<T> vector2)
		{
			return Add(vector1, Negate(vector2));
		}

		#endregion

		#endregion

		#region vector -> vector ^Z

		#region 

		/// <summary>
		/// xNg̔]s
		/// </summary>
		public static IVector<T> Negate(IVector<T> vector)
		{
			IVector<T> r = (IVector<T>)vector.Clone();

			foreach (T key in vector.Keys)
			{
				r[key] = -vector[key];
			}

			return r;
		}

		#endregion

		#endregion

		#region scalar * vector -> vector ^Z

		#region xNg

		/// <summary>
		/// xNg̒萔{s
		/// </summary>
		static public IVector<T> Multiply(double scalar, IVector<T> vector)
		{
			IVector<T> r = (IVector<T>)vector.Clone();

			foreach (T key in vector.Keys)
			{
				r[key] = scalar * r[key];
			}

			return r;
		}
		#endregion

		#endregion
	}
}
