using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Globalization;
using System.Threading;
using Microsoft.VisualBasic;

namespace SlothLib.NLP
{
	/// <summary>
	/// 񂩂當ɕϊtB^W߂NX
	/// </summary>
	/// <remarks>
	/// 
	/// [TODO]Rg
	/// 
	/// <newpara>[2007-05-01][tkoba]쐬</newpara>
	/// <newpara>[2007-05-09][ohshima]C</newpara>
	/// </remarks>
	public class Filter
	{

		/// <summary>
		/// staticRXgN^
		/// </summary>
		static Filter()
		{
			mapNumKanjiToNumRoman.Add("Z", "0");
			mapNumKanjiToNumRoman.Add("", "1");
			mapNumKanjiToNumRoman.Add("", "2");
			mapNumKanjiToNumRoman.Add("O", "3");
			mapNumKanjiToNumRoman.Add("l", "4");
			mapNumKanjiToNumRoman.Add("", "5");
			mapNumKanjiToNumRoman.Add("Z", "6");
			mapNumKanjiToNumRoman.Add("", "7");
			mapNumKanjiToNumRoman.Add("", "8");
			mapNumKanjiToNumRoman.Add("", "9");
		}

		#region statictB[h

		/// <summary>
		/// ToTitleCase𗘗p邽߂TextInfo
		/// </summary>
		private static readonly TextInfo textInfo = Thread.CurrentThread.CurrentCulture.TextInfo;

		/// <summary>
		/// Spɂ邽߂MatchEvaluator
		/// </summary>
		private static readonly MatchEvaluator toWideMatchEvaluator = new MatchEvaluator(MatchToWide);

		/// <summary>
		/// pɂ邽߂MatchEvaluator
		/// </summary>
		private static readonly MatchEvaluator toNarrowMatchEvaluator = new MatchEvaluator(MatchToNarrow);

		/// <summary>
		/// pɃ}b`鐳K\
		/// </summary>
		private static readonly Regex alphaDigitRegex = new Regex(@"[-`-yO-X]+", RegexOptions.Compiled);

		/// <summary>
		/// pJ^JiɃ}b`鐳K\
		/// </summary>
		private static readonly Regex halfKanaRegex = new Regex(@"[-]+", RegexOptions.Compiled);

		/// <summary>
		/// SpLɃ}b`鐳K\
		/// </summary>
		/// <remarks>SpĹIhfij|Obeop{FGQHmn^_CD</remarks>
		private static readonly Regex wideSymbolRegex = new Regex(@"[Ihfij|Obeop{FGQHmn^_CD]", RegexOptions.Compiled);


		private static string MatchToWide(Match m)
		{
			// }b`p擾
			string half = m.Value;
			// Spɂ
			string wide = Strings.StrConv(half, VbStrConv.Wide, 0);
			// uԂ
			return wide;
		}


		private static string MatchToNarrow(Match m)
		{
			// }b`Sp擾
			string wide = m.Value;
			// pɂ
			string half = Strings.StrConv(wide, VbStrConv.Narrow, 0);
			// uԂ
			return half;
		}

		#endregion


		/// <summary>
		/// K\gătB^OBincludeɃ}b`AexcludeɃ}b`Ȃ̂c
		/// </summary>
		/// <param name="str">͕</param>
		/// <param name="include">cɃ}b`鐳K\</param>
		/// <param name="exclude">O镶Ƀ}b`鐳K\</param>
		/// <returns>tB^Kp̕BOꂽꍇnullԂ</returns>
		public static string RegexFilter(string str, Regex include, Regex exclude)
		{
			//includeexcludenullȂX[邾
			if (include != null)
			{
				if (!include.Match(str).Success)
				{
					return null;
				}
			}
			if (exclude != null)
			{
				if (exclude.Match(str).Success)
				{
					return null;
				}
			}
			// i
			return str;
		}


		#region 啶Sppn

		/// <summary>
		/// ɂ
		/// </summary>
		/// <param name="str">tB^Kp镶</param>
		/// <returns>tB^Kp̕</returns>
		public static string ToLower(string str)
		{
			if (str != null)
			{
				return str.ToLower();
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// 啶ɂ
		/// </summary>
		/// <param name="str">tB^Kp镶</param>
		/// <returns>tB^Kp̕</returns>
		public static string ToUpper(string str)
		{
			if (str != null)
			{
				return str.ToUpper();
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// ëꕶڂ݂̂啶ɂāAcɂB
		/// </summary>
		/// <param name="str">tB^Kp镶</param>
		/// <returns>tB^Kp̕</returns>
		public static string ToTitleCase(string str)
		{
			if (str != null)
			{
				return textInfo.ToTitleCase(str);
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// pɂB
		/// J^JiǓ_pɂȂ̂ŒӁB
		/// </summary>
		/// <param name="str">tB^Kp镶</param>
		/// <returns>tB^Kp̕</returns>
		public static string ToNarrow(string str)
		{
			if (str != null)
			{
				return Strings.StrConv(str, VbStrConv.Narrow, 0);
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// SpɂB
		/// ppLSpɂȂ̂ŒӁB
		/// </summary>
		/// <param name="str">tB^Kp镶</param>
		/// <returns>tB^Kp̕</returns>
		public static string ToWide(string str)
		{
			if (str != null)
			{
				return Strings.StrConv(str, VbStrConv.Wide, 0);
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// pJ^JiEǓ_݂̂SpɂB
		/// </summary>
		/// <param name="str">tB^Kp镶</param>
		/// <returns>tB^Kp̕</returns>
		public static string HalfKanaToWide(string str)
		{
			if (str != null)
			{
				return halfKanaRegex.Replace(str, toWideMatchEvaluator);
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// p݂̂𔼊pɂB
		/// </summary>
		/// <param name="str">tB^Kp镶</param>
		/// <returns>tB^Kp̕</returns>
		public static string AlphaDigitToNarrow(string str)
		{
			if (str != null)
			{
				return alphaDigitRegex.Replace(str, toNarrowMatchEvaluator);
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// pJ^JiEǓ_SpɁAp𔼊pɂB
		/// </summary>
		/// <param name="str">tB^Kp镶</param>
		/// <returns>tB^Kp̕</returns>
		public static string AlphaDigitToNarrowHalfKanaToWide(string str)
		{
			if (str != null)
			{
				string r = str;
				r = alphaDigitRegex.Replace(r, toNarrowMatchEvaluator);
				r = halfKanaRegex.Replace(r, toWideMatchEvaluator);
				return r;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// SpL݂̂𔼊pLɂB
		/// </summary>
		/// <param name="str">tB^Kp镶</param>
		/// <returns>tB^Kp̕</returns>
		public static string SymbolToNarrow(string str)
		{
			if (str != null)
			{
				return wideSymbolRegex.Replace(str, toNarrowMatchEvaluator);
			}
			else
			{
				return null;
			}
		}

		#endregion


		#region ln

		#region K\

		/// <summary>
		/// ܂ƂȐl\Ƀ}b`鐳K\
		/// Spł}b`B
		/// </summary>
		private static readonly Regex numRegex = new Regex(@"\d+([,C]\d+)*([\.D]\d+)?", RegexOptions.Compiled);

		/// <summary>
		/// I\Ƀ}b`鐳K\
		/// </summary>
		private static readonly Regex numUseKanjiRegex = new Regex("[ZOlܘZ]+([,CA][ZOlܘZ]+)*", RegexOptions.Compiled);

		/// <summary>
		/// \炵̂Ƀ}b`鐳K\̈i
		/// </summary>
		private static readonly Regex numKanjiPre1Regex = new Regex("[OlܘZ\S疜]+", RegexOptions.Compiled);

		/// <summary>
		/// \炵̂Ƀ}b`鐳K\̓i
		/// </summary>
		private static readonly Regex numKanjiPre2Regex = new Regex("(?<M4>.+)?(?<M3>.+)?(?<M2>.+)?(?<M1>.+)?(?<M0>.+)?", RegexOptions.Compiled);

		/// <summary>
		/// ꖜ̊\Ƀ}b`鐳K\
		/// Zɂ̓}b`ȂAƂɖ͂Ȃ
		/// </summary>
		private static readonly Regex numKanjiSenRegex = new Regex("(?<K3>([OlܘZ]?)?)(?<K2>([OlܘZ]?S)?)(?<K1>([OlܘZ]?\)?)(?<K0>[OlܘZ]?)", RegexOptions.Compiled);

		/// <summary>
		/// 1Ƀ}b`鐳K\
		/// </summary>
		private static readonly Regex numKanjiOneRegex = new Regex("[ZOlܘZ]", RegexOptions.Compiled);

		/// <summary>
		/// numKanjiOneRegexŃ}b`eɑΉ郍[}̃}bv
		/// </summary>
		private static readonly Dictionary<string, string> mapNumKanjiToNumRoman = new Dictionary<string, string>();

		/// <summary>
		/// 1[}ɂ邽߂MatchEvaluator
		/// </summary>
		private static readonly MatchEvaluator numKanjiToNumRomanMatchEvaluator = new MatchEvaluator(MatchNumKanjiToNumRoman);

		/// <summary>
		/// numKanjiToNumRomanMatchEvaluator̂߂̃\bh
		/// </summary>
		/// <param name="m"></param>
		/// <returns></returns>
		private static string MatchNumKanjiToNumRoman(Match m)
		{
			return mapNumKanjiToNumRoman[m.Value];
		}

		/// <summary>
		/// ̗\琔lɕϊ郁\bh
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		private static long NumKanjiToNum(string str)
		{
			return long.Parse(numKanjiOneRegex.Replace(str, numKanjiToNumRomanMatchEvaluator));
		}

		/// <summary>
		/// ̈ꖜ̕\𐔒lɕϊ郁\bh
		/// </summary>
		/// <param name="str"></param>
		/// <returns></returns>
		private static long KanjiNumSenToNum(string str)
		{
			Match numKanjiSenMatch = numKanjiSenRegex.Match(str);
			if (numKanjiSenMatch.Success)
			{
				long val = 0;
				string[] keta = new string[4];

				for (int i = 0; i < 4; i++)
				{
					keta[i] = numKanjiSenMatch.Groups["K" + i.ToString()].Value;
				}

				if (keta[0].Length == 1)
				{
					val += NumKanjiToNum(keta[0]);
				}
				for (int i = 1; i < 4; i++)
				{
					if (keta[i].Length == 1)
					{
						val += (long)System.Math.Pow(10, i);
					}
					else if (keta[i].Length == 2)
					{
						val += (long)System.Math.Pow(10, i) * NumKanjiToNum(keta[i].Substring(0, 1));
					}
				}
				return val;
			}

			Match numUseKanjiMatch = numUseKanjiRegex.Match(str);
			if (numUseKanjiMatch.Success)
			{
				return NumKanjiToNum(str);
			}
			return 0;
		}

		#endregion

		/// <summary>
		/// 𐔒lƂĉ߂Ap̕ɂĕԂB
		/// [TODO]eXg܂s\łOԂꍇ邩ȂB
		/// [TODO]uSvƂ̂0ԂB
		/// [TODO]u30vȂǂɑΉĂȂB
		/// </summary>
		/// <param name="str">tB^Kp镶</param>
		/// <returns>tB^Kp̕</returns>
		public static string ToNumerical(string str)
		{
			// ܂͂܂ƂȐl\ǂ𒲂ׂB
			Match numMatch = numRegex.Match(str);
			if (numMatch.Success)
			{
				return double.Parse(ToNarrow(numMatch.Value)).ToString();
			}

			// Ƃ肠Al̗ɂ\炵ǂׂĂ݂B
			Match numUseKanjiMatch = numUseKanjiRegex.Match(str);
			if (numUseKanjiMatch.Success)
			{
				string v = numUseKanjiMatch.Value;
				if (v.Length >= 2)
				{
					// l̗ɂ\ƔB
					string removeComma = v.Replace(",", "").Replace("C", "").Replace("A", "");
					return NumKanjiToNum(removeComma).ToString();
				}
			}

			// \ǂׂĂ݂B
			Match numKanjiPre1Match = numKanjiPre1Regex.Match(str);
			if (numKanjiPre1Match.Success)
			{
				Match numKanjiPre2Match = numKanjiPre2Regex.Match(numKanjiPre1Match.Value);
				if (numKanjiPre2Match.Success)
				{

					long val = 0;
					string[] mann = new string[5];

					for (int i = 0; i < 5; i++)
					{
						mann[i] = numKanjiPre2Match.Groups["M" + i.ToString()].Value;
					}

					val += KanjiNumSenToNum(mann[0]);

					for (int i = 1; i < 5; i++)
					{
						if (mann[i].Length >= 2)
						{
							val += (long)System.Math.Pow(10, i * 4) * KanjiNumSenToNum(mann[i].Substring(0, mann[i].Length - 1));
						}
					}
					return val.ToString();
				}
			}
			return "0";
		}

		#endregion

	}
}
