using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace SlothLib.NLP
{
    /// <summary>
    /// w肵î݂otB^
    /// </summary>
	public class PosFilter : AbstractMorphemeFilter
	{
		// i؂op
		private Regex regexInclude = null;
		private Regex regexExclude = null;


		#region RXgN^
        /// <summary>
        /// RXgN^
        /// includePosɃ}b`āCexcludePosɂ̓}b`Ȃio
        /// </summary>
        /// <param name="includePos">oΏۂɂ镶iuvȂǁj̔z</param>
        /// <param name="excludePos">oΏۊO̕iu-ŗLvȂǁj̔z</param>
		public PosFilter(string[] includePos, string[] excludePos)
		{
			string includePosRegex = null;
			if(includePos != null)
			{
				StringBuilder sbInclude = new StringBuilder();
				for (int i = 0; i < includePos.Length; i++)
				{
					sbInclude.Append(includePos[i]);
					sbInclude.Append("|");
				}
				sbInclude.Remove(sbInclude.Length - 1, 1);
				includePosRegex = sbInclude.ToString();
			}

			string excludePosRegex = null;
			if (excludePos != null)
			{
				StringBuilder sbExclude = new StringBuilder();
				for (int i = 0; i < excludePos.Length; i++)
				{
					sbExclude.Append(excludePos[i]);
					sbExclude.Append("|");
				}
				sbExclude.Remove(sbExclude.Length - 1, 1);
				excludePosRegex = sbExclude.ToString();
			}

			this.Initialize(includePosRegex, excludePosRegex);
		}

        /// <summary>
        /// RXgN^
        /// includePosɃ}b`io
        /// </summary>
        /// <param name="includePos">oΏۂɂ镶iuvȂǁj̃Xg</param>
		public PosFilter(string[] includePos)
			: this(includePos, null)
		{ }

        /// <summary>
        /// RXgN^
        /// includePosRegex̐K\Ƀ}b`āAexcludePosRegexɃ}b`Ȃio
        /// </summary>
        /// <param name="includePosRegex">oΏۂɂ鐳K\iu|vȂǁj</param>
        /// <param name="excludePosRegex">oΏۊOɂ鐳K\iu-(㖼|ŗL)vȂǁj</param>
		public PosFilter(string includePosRegex, string excludePosRegex)
		{
			this.Initialize(includePosRegex, excludePosRegex);
		}

        /// <summary>
        /// RXgN^
        /// includePosRegex̐K\Ƀ}b`io
        /// </summary>
        /// <param name="includePosRegex">oΏۂɂ鐳K\iu|vȂǁj</param>
		public PosFilter(string includePosRegex)
			: this(includePosRegex, null)
		{ }

		private void Initialize(string includePosRegex, string excludePosRegex)
		{
			if (!string.IsNullOrEmpty(includePosRegex))
			{
				this.regexInclude = new Regex("^(" + includePosRegex + ").*?$", RegexOptions.Compiled);
			}
			if (!string.IsNullOrEmpty(excludePosRegex))
			{
				this.regexExclude = new Regex("^(" + excludePosRegex + ").*?$", RegexOptions.Compiled);
			}
		}

		#endregion

        /// <summary>
        /// w肵î݂o
        /// </summary>
        /// <param name="morpheme">tB^KpΏۂ̌`ԑf</param>
        /// <returns>tB^Kp̌`ԑf</returns>
		public override IMorpheme DoFilter(IMorpheme morpheme)
		{
			string pos = morpheme.POS;

			if (string.IsNullOrEmpty(pos))
			{
				return null;
			}

			// include
			if (this.regexInclude == null || this.regexInclude.Match(pos).Success)
			{
				// exclude
				if (this.regexExclude == null || !this.regexExclude.Match(pos).Success)
				{
					return morpheme;
				}
			}
			return null;
		}

	}
}
