using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;
using Microsoft.Win32;
using Microsoft.VisualBasic;

namespace SlothLib.NLP
{
	/// <summary>
	/// `ԑf͊u⣁v𗘗pNXB
	/// chasen.exesB
	/// </summary>
	/// <remarks>
	/// ̃NX𗘗p邽߂ɂ͕ʓrA⣂Windows2.3.3܂2.4.0CXg[Kv܂B
	/// http://sourceforge.jp/projects/chasen-legacy/
	/// ⣂̗pɂchasen.exechasenrc̈ʒuw肷Kv܂B
	/// ⣂CXg[[Uł́AWXgɏ񂪏܂Ă邽߂𐄒肷邱Ƃł܂B
	/// ̃NXg\tgEFAAdministrators[Uł΁Ã[UŒ⣂CXg[邱ƂɂAL肪\ɂȂ܂B
	/// AUsersȂꍇA̐sƂł܂񂵁ACXg[chasenrĉ݂ł͎𔭌邱Ƃł܂B
	/// Sɂ̃NX𗘗pɂ́AIchasen.exechasenrcw肵Achasenrcɂ͎̃tpXݒ̂ǂƂƂłB
	/// ܂A⣂ł͖mɑ΂Č`o͂܂B̂߁Am̌`͏o`Ɠ̂Ă܂B
	/// MeCabł̖͂͂܂B
	/// <newpara>[2007-04-21][ohshima]쐬</newpara>
	/// </remarks>
	public class ChaSen : IMorphologicalAnalyzer
	{

		#region private tB[h

		/// <summary>
		/// chasen.exe ̃pX
		/// </summary>
		private string chaSenPath;

		/// <summary>
		/// chasenrc ̃pX
		/// </summary>
		private string chaSenRcPath;

		/// <summary>
		/// jIvVp
		/// </summary>
		private string option = "";

		#endregion


		#region private static tB[h

		/// <summary>
		/// pJiʗp̐K\
		/// </summary>
		private static Regex regexHalfKana = new Regex(@"^([^-]*)([-]*)(.*)$", RegexOptions.Compiled | RegexOptions.Singleline);

		/// <summary>
		/// 𐶐
		/// </summary>
		private static Random random = new Random();

		#endregion

		#region RXgN^

		/// <summary>
        /// RXgN^B⣂̃ftHg̐ݒ𗘗pB
		/// ⣂CXg[[UȊOł̓WXgɏ񂪖ߗpłȂB
		/// </summary>
		public ChaSen() 
		{
            // chasen.exe  chasenrc ̃pXWXg̏ɐݒ肷B
            this.ChaSenPath = GetChaSenPath();
            this.ChaSenRcPath = GetChaSenRcPath();
        }

        /*
		/// <summary>
		/// RXgN^B⣂̃ftHg̐ݒ𗘗pB
		/// ⣂CXg[[UȊOł̓WXgɏ񂪖ߗpłȂB
		/// </summary>
		/// <param name="useOption_j">⣎s-jIvVtꍇtrueB</param>
		public ChaSen(bool useOption_j)
		{
			// chasen.exe  chasenrc ̃pXWXg̏ɐݒ肷B
			this.SetChaSenPath(GetChaSenPath());
			this.SetChaSenRcPath(GetChaSenRcPath());
			// -jIvV̐ݒ
			if (useOption_j)
			{
				this.option = "-j ";
			}
		}
         */

        /// <summary>
        /// RXgN^BpX̏w肷
        /// </summary>
        /// <param name="chaSenPath"></param>
        /// <param name="chaSenRcPath"></param>
		public ChaSen(string chaSenPath, string chaSenRcPath)
		{
            this.ChaSenPath = chaSenPath;
            this.ChaSenRcPath = chaSenRcPath;
        }

        /*
        /// <summary>
        /// RXgN^BpX-jIvVw肷
        /// </summary>
        /// <param name="chaSenPath"></param>
        /// <param name="chaSenRcPath"></param>
        /// <param name="useOption_j"></param>
		public ChaSen(string chaSenPath, string chaSenRcPath, bool useOption_j)
		{
			SetChaSenPath(chaSenPath);
			SetChaSenRcPath(chaSenRcPath);
			// -jIvV̐ݒ
			if (useOption_j)
			{
				this.option = "-j ";
			}
		}
        */

		#endregion


		#region vpeBn

        /// <summary>
        /// chasen.exẽpX
        /// </summary>
		public string ChaSenPath
        {
            get { return this.chaSenPath; }
            set
            {
                if (!File.Exists(value))
                {
                    throw new FileNotFoundException("chasen.exe邱Ƃł܂łB", value);
                }
                this.chaSenPath = value;
            }
		}

        /// <summary>
        /// chasenrc̃pX
        /// </summary>
		public string ChaSenRcPath
		{
            get { return this.chaSenRcPath; }
            set
            {
                if (!File.Exists(value))
                {
                    throw new FileNotFoundException("chasenrc邱Ƃł܂łB", value);
                }
                this.chaSenRcPath = value;
            }
		}

        /// <summary>
        /// ⣎s-jIvVtꍇtrueB
        /// </summary>
        private bool Option_j
        {
            get
            {
                return (this.option == "-j ");
            }
            set
            {
                if (value)
                {
                    this.option = "-j ";
                }
                else
                {
                    this.option = string.Empty;
                }
            }
        }

		#endregion


		#region C̃\bh DoAnalyze

        /// <summary>
        /// ChaSenŌ`ԑf͂s
        /// </summary>
        /// <param name="text">͑Ώۂ̃eLXg</param>
        /// <returns>͌</returns>
		public ChaSenResult DoAnalyze(string text)
		{

			if (text == null)
			{
				throw new ArgumentNullException("text", "nullłB");
			}

			// t@CpX
			string tempFilePath;
			do
			{
				tempFilePath = Path.GetTempPath() + "SlothLib.NLP.ChaSen.DoAnalyze." + text.GetHashCode() + "." + random.Next().ToString() + ".tmp";
			} while (File.Exists(tempFilePath));

			// Rec̏o
			using (StreamWriter sw = new StreamWriter(tempFilePath, false, System.Text.Encoding.GetEncoding("shift_jis")))
			{
				string sLine = text;
				while (sLine.Length > 0)
				{
					Match mHalfKana = regexHalfKana.Match(sLine);
					// pJiȂt@Cɏo
					sw.Write(mHalfKana.Groups[1].ToString());

					// pJi̕
					string partHalfKana = mHalfKana.Groups[2].ToString();
					if (partHalfKana.Length > 0)
					{
						sw.Write(Strings.StrConv(partHalfKana, VbStrConv.Wide, 0));
					}
					// c͐̕VɏȂƂˁB
					sLine = mHalfKana.Groups[3].ToString();
				}
			}

			// ChaSen̐
			string parsedText = ParseFile(tempFilePath);

            try
            {
                // ꎞt@CsvɂȂ͂Ȃ̂ŁA폜B
                // OHȂ񖳎łB
                File.Delete(tempFilePath);
            }
            catch { }

			return new ChaSenResult(parsedText);
		}

		/// <summary>
		/// eLXgt@CǂݍŌ`ԑf͂B
		/// </summary>
		/// <param name="tempFilePath">eLXgt@C̃pXB</param>
		/// <returns>ChaSen̉͌</returns>
		private string ParseFile(string tempFilePath)
		{
			// W͂ɏłAchasenɃt@CH킹B
			// ɃeLXg傫Ȃɏ]ĒiႢɂȂB
			// vZX쐬Ƃ낢
			System.Diagnostics.Process p = new System.Diagnostics.Process();
			p.StartInfo.FileName = this.ChaSenPath;
			p.StartInfo.Arguments = @"-r """ + this.ChaSenRcPath + @""" " + this.option + @"-f """ + tempFilePath + @"""";
			p.StartInfo.CreateNoWindow = true;
			p.StartInfo.UseShellExecute = false;
			// Wo͂ǂݍ
			// Ȃ݂ɁAt@Co͂ɂAWo͂EiƂAx͂قƂǕςȂA̕jB
			p.StartInfo.RedirectStandardOutput = true;
			p.Start();
			string output = p.StandardOutput.ReadToEnd();
			p.WaitForExit();
			int ec = p.ExitCode;
			p.Close();
			if (ec != 0)
			{
				throw new Exception("chasen.exe̎sɃG[N܂B");
			}
			return output;
		}

		#endregion


		#region public static \bh

        /// <summary>
        /// WXgchasen.exẽpX擾
        /// </summary>
        /// <returns>chasen.exẽpX</returns>
		public static string GetChaSenPath()
		{
			// @t@C̈ʒu
			string grammarPath = GetGrammarPath();
			// W̎fBNg̐eChaSeñpXƂĂ̈Ԃ̌łB
			string chaSenPath = grammarPath.Substring(0, grammarPath.LastIndexOf("\\")) + "\\chasen.exe";
			if (!File.Exists(chaSenPath))
			{
				throw new FileNotFoundException("chasen.exe܂łB", chaSenPath);
			}
			return chaSenPath;
		}

        /// <summary>
        /// WXgchasenrc̃pX擾
        /// </summary>
        /// <returns>chasenrc̃pX</returns>
		public static string GetChaSenRcPath()
		{
			// ChaSen֘ÃWXgL[
			RegistryKey rkChaSen = Registry.CurrentUser.OpenSubKey(@"Software\NAIST\ChaSen", false);

			try
			{
				// Wchasenrc̃pX߂B
				string chaSenRcPath = rkChaSen.GetValue("chasenrc").ToString();
				return chaSenRcPath;
			}
			catch
			{
				throw new ApplicationException("WXgɒ⣂Ɋւ񂪂݂܂łB");
			}
		}

		private static string GetGrammarPath()
		{
			// ChaSen֘ÃWXgL[
			RegistryKey rkChaSen = Registry.CurrentUser.OpenSubKey(@"Software\NAIST\ChaSen", false);

			try
			{
				// W̎fBNg̃pX߂B
				string grammarPath = rkChaSen.GetValue("grammar").ToString();
				return grammarPath;
			}
			catch
			{
				throw new ApplicationException("WXgɒ⣂Ɋւ񂪂݂܂łB");
			}
		}

		#endregion


		#region IMorphologicalAnalyzer o

		IMorphologicalAnalyzerResult IMorphologicalAnalyzer.DoAnalyze(string text)
		{
			return this.DoAnalyze(text);
		}

		#endregion
	}
}