using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.NLP
{
	/// <summary>
	/// ⣂̏o͂`ԑf̃NX
	/// </summary>
	/// <remarks>
	/// 
	/// <newpara>[2007-04-21][ohshima]쐬</newpara>
	/// </remarks>
	public class ChaSenMorpheme : Morpheme, IMorpheme
	{
        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="raw">o`</param>
        /// <param name="reading">ǂ</param>
        /// <param name="original">`</param>
        /// <param name="pos">i</param>
        /// <param name="conjugationPattern">p^</param>
        /// <param name="conjugationForm">p`</param>
		public ChaSenMorpheme(string raw, string reading, string original, string pos, string conjugationPattern, string conjugationForm)
			: base(pos,raw,original)
		{
			this.reading = reading;
			this.conjugationPattern = conjugationPattern;
			this.conjugationForm = conjugationForm;
		}

		// ǂ
		private string reading;
		// p^
		private string conjugationPattern;
		// p`
		private string conjugationForm;

		/// <summary>
		/// ǂ
		/// </summary>
		public string Reading
		{
            get { return this.reading; }
		}

		/// <summary>
		/// p̎ށBChaSeñ}jAł́up^vƂȂĂ
		/// </summary>
		public string ConjugationPattern
		{
            get { return this.conjugationPattern; }
		}

		/// <summary>
		/// p`
		/// </summary>
		public string ConjugationForm
		{
            get { return this.conjugationForm; }
		}

        /// <summary>
        /// "(o`)\t(ǂ)\t(`)\t(i)\t(p̎)\t(p`)"̌`̕Ԃ
        /// </summary>
        /// <returns></returns>
		public override string ToString()
		{
			return this.Raw + "\t" + this.Reading + "\t" + this.Original + "\t" + this.POS + "\t" + this.ConjugationPattern + "\t" + this.ConjugationForm;
		}


	}
}
