using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace SlothLib.NLP
{
	/// <summary>
	/// ⣂̏o͌ʁB
	/// </summary>
	/// <remarks>
	/// 
	/// [TODO]EOSƂ̌ʂ߂̂́A\bhĂяoꂽƂɂ΂̂ł͂ȂB
	/// MeCab̂悤ɁBāAȂƏԂɂƂbłˁB͂B
	/// <newpara>[2007-04-21][ohshima]쐬</newpara>
	/// </remarks>
	public class ChaSenResult : IMorphologicalAnalyzerResult
    {

        #region private tB[h

        private  List<ChaSenMorpheme> morphemeList;

		/// <summary>
		/// ⣂̐̌
		/// </summary>
		private string rawResult;

		/// <summary>
		/// EOSƂ̌
		/// </summary>
		private List<ChaSenResult> sequenceResults;


        //GetOriginalArray()邽߂̃tB^
        private static RemainOriginalFilter remainOriginalFilter = new RemainOriginalFilter();
        private static RemainPosFilter remainPosFilter = new RemainPosFilter();
        private static RemainRawFilter remainRawFilter = new RemainRawFilter();


		/// <summary>
		/// ⣂-fIvV̏o͂Ƀ}b`鐳K\
		/// </summary>
		private static Regex regexResultLine = new Regex(@"^(.*)\t(.*)\t(.*)\t(.*)\t(.*)\t(.*)$", RegexOptions.Compiled | RegexOptions.Singleline);

        #endregion


        #region RXgN^

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="rawResult">ChaSeno͂鐶̌</param>
		public ChaSenResult(string rawResult)
		{
            this.morphemeList = new List<ChaSenMorpheme>();

			this.rawResult = rawResult;
			this.sequenceResults = new List<ChaSenResult>();

			// sƂɐ؂蕪B
			List<string> resultList = new List<string>(rawResult.Split(new string[] { "\r\n", "\r", "\n" }, StringSplitOptions.None));

			// EOSƂ̌ʂꎞIɎĂ߂̕ϐB
			StringBuilder sequenceRawResult = new StringBuilder();
			List<ChaSenMorpheme> sequenceMorphemes = new List<ChaSenMorpheme>();


			// sƂɌĂB
			foreach (string line in resultList)
			{
				Match match = regexResultLine.Match(line);
				if (match.Success)
				{
					string raw = match.Groups[1].ToString();
					string reading = match.Groups[2].ToString();
					string original = match.Groups[3].ToString();
					string pos = match.Groups[4].ToString();
					string conjugationPattern = match.Groups[5].ToString();
					string conjugationForm = match.Groups[6].ToString();

                    // originalȂraw
                    if (string.IsNullOrEmpty(original))
                    {
                        original = raw;
                    }

					ChaSenMorpheme morpheme = new ChaSenMorpheme(raw, reading, original, pos, conjugationPattern, conjugationForm);

					this.morphemeList.Add(morpheme);

					// EOSƂ̌ʎ擾p
					sequenceRawResult.Append(line + "\r\n");
					sequenceMorphemes.Add(morpheme);
				}
				else
				{
                    if (line == "EOS")
                    {
                        this.sequenceResults.Add(new ChaSenResult(sequenceRawResult.ToString(), sequenceMorphemes));

                        // EOSƂ̌ʎ擾p
                        sequenceRawResult = new StringBuilder();
                        sequenceMorphemes = new List<ChaSenMorpheme>();
                    }
                    else
                    {
                        if (!string.IsNullOrEmpty(line))
                        {
                            System.Diagnostics.Debug.WriteLine("ChaSeno͂s̉͂Ɏs܂");
                        }
                    }
				}
			}

		}


		private ChaSenResult(string rawResult, List<ChaSenMorpheme> sequenceMorphemes)
		{
            this.morphemeList = new List<ChaSenMorpheme>();

			this.rawResult = rawResult;
			foreach (ChaSenMorpheme morpheme in sequenceMorphemes)
			{
				this.morphemeList.Add(morpheme);
			}
        }

        #endregion


        #region vpeBȂ

        /// <summary>
		/// ⣂o͂̌ʁB
		/// </summary>
		public string RawResult
		{
            get { return this.rawResult; }
		}

        /// <summary>
        /// EOSƂ̌ʂ̐
        /// </summary>
		public int SequenceCount
		{
            get { return this.sequenceResults.Count; }
		}

        /// <summary>
        /// i[`ԑf̔z
        /// </summary>
        public ChaSenMorpheme[] Morphemes
        {
            get
            {
                return this.morphemeList.ToArray();
            }
        }

        /// <summary>
        /// EOSƂɌʂ𕪂ĕԂ
        /// </summary>
        /// <returns>EOSƂɕꂽChaSenResult̔z</returns>
		public ChaSenResult[] GetSequenceResults()
		{
            return this.sequenceResults.ToArray();
		}

        /// <summary>
        /// CfNT
        /// </summary>
        /// <param name="index">`ԑf̔ԍ</param>
        /// <returns>indexԖڂ̌`ԑf</returns>
		public ChaSenMorpheme this[int index]
		{
            get { return (ChaSenMorpheme)this.morphemeList[index]; }
        }

        #endregion


        #region IMorphologicalAnalyzerResult o

        IMorpheme[] IMorphologicalAnalyzerResult.Morphemes
        {
            get
            {
                return this.morphemeList.ToArray();
            }
        }

        /// <summary>
        /// e`ԑfRawzɂĕԂ
        /// </summary>
        /// <returns>Raw̔z</returns>
        public string[] GetRawArray()
        {
            return remainRawFilter.DoFilter(this.Morphemes);
        }

        /// <summary>
        /// e`ԑfOriginalzɂĕԂ
        /// </summary>
        /// <returns>Original̔z</returns>
        public string[] GetOriginalArray()
        {
            return remainOriginalFilter.DoFilter(this.Morphemes);
        }

        /// <summary>
        /// e`ԑfPOSzɂĕԂ
        /// </summary>
        /// <returns>POS̔z</returns>
        public string[] GetPOSArray()
        {
            return remainPosFilter.DoFilter(this.Morphemes);
        }

        #endregion
    }
}
