using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.NLP
{
	/// <summary>
    /// MeCab̏o͂`ԑf̃NX
	/// </summary>
	/// <remarks>
	/// <newpara>[2007-04-22][ohshima]쐬</newpara>
	/// </remarks>
	public class MeCabMorpheme : Morpheme, IMorpheme
	{

		// \w`\ti,iו1,iו2,iו3,p`,p^,`,ǂ,

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="raw">\w`</param>
        /// <param name="pos">i</param>
        /// <param name="conjugationPattern">p`BʓIɂ͊p̎</param>
        /// <param name="conjugationForm">p^BʓIɂ͊p`</param>
        /// <param name="original">`</param>
        /// <param name="reading">ǂ</param>
        /// <param name="pronunciation"></param>
		public MeCabMorpheme(string raw, string pos, string conjugationPattern, string conjugationForm, string original, string reading, string pronunciation)
			: base(pos,raw,original)
		{
			this.reading = reading;
			this.conjugationPattern = conjugationPattern;
			this.conjugationForm = conjugationForm;
			this.pronunciation = pronunciation;
		}

		// ǂ
		private string reading;
		// p^
		private string conjugationPattern;
		// p`
		private string conjugationForm;
		// 
		private string pronunciation;

		/// <summary>
		/// ǂ
		/// </summary>
		public string Reading
		{
            get { return this.reading; }
		}

		/// <summary>
		/// p̎ށBMeCab̃}jAł́up`vƂȂĂ
		/// </summary>
		/// <remarks>
		/// MeCab̃}jAȂǂł́up`vƂȂĂ܂Au⣁vŌƂ̊p^łAܒipAƂ悤Ȍ݂̊p̎ނ̂ƂłB
		/// </remarks>
		public string ConjugationPattern
		{
            get { return this.conjugationPattern; }
		}

		/// <summary>
		/// p`BMeCab̃}jAł́up^vƂȂĂ
		/// </summary>
		/// <remarks>
		/// MeCab̃}jAȂǂł́up^vƂȂĂ܂Au⣁vŌƂ̊p`łAR`AAp`AƂ悤Ȍ݂̊p̌`̂ƂłB
		/// </remarks>
		public string ConjugationForm
		{
            get { return this.conjugationForm; }
		}

		/// <summary>
		/// 
		/// </summary>
		public string Pronunciation
		{
            get { return this.pronunciation; }
		}

        /// <summary>
        /// "(o`)\t(i),(p̎),(p`),(`),(ǂ),()"̌`̕Ԃ
        /// </summary>
        /// <returns></returns>
		public override string ToString()
		{
			return this.Raw + "\t" + this.POS + "," + this.ConjugationPattern + "," + this.ConjugationForm + "," + this.Original + "," + this.Reading + "," + this.Pronunciation;
		}




	}
}
