﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    /// <summary>
    /// ウェブ検索テスト用のフォーム
    /// </summary>
    public partial class FormIImage : Form
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public FormIImage()
        {
            InitializeComponent();
            cbSearchEngine.SelectedIndex = 0;
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            IImageSearch search;
            switch (cbSearchEngine.Text)
            {
                default:
                case "YahooJpImage":
                    search = new YahooJpImageSearch("slothlib");
                    break;
                case "Flickr":
                    search = new FlickrSearch("945e41273602152763825a2c31060a35");
                    break;
            }

            IImageSearchResult result = search.DoSearch(tbQuery.Text, int.Parse(cbMaxNum.Text));

            lblTotalNumber.Text = result.TotalNumber.ToString() + "件";

            lvResult.Items.Clear();
            foreach (IImageElement element in result.ResultElements)
            {
                ListViewItem item = new ListViewItem(element.Title);
                item.SubItems.Add(element.URL);
                item.SubItems.Add(element.Description);
                lvResult.Items.Add(item);
            }
        }

        private void lvResult_DoubleClick(object sender, EventArgs e)
        {
            foreach (ListViewItem item in lvResult.SelectedItems)
            {
                System.Diagnostics.Process.Start(item.SubItems[1].Text);
            }

        }
    }
}