using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    public partial class FormYahooJpImage : Form
    {
        public FormYahooJpImage()
        {
            InitializeComponent();
        }

        private void buttonSearch_Click(object sender, EventArgs e)
        {
            YahooJpImageSearch search = new YahooJpImageSearch("slothlib"); ;

            // ^CvZbg
            switch (cbType.Text)
            {
                case "all":
                    search.Type = YahooJpImageSearch.SearchType.all;
                    break;
                case "any":
                    search.Type = YahooJpImageSearch.SearchType.any;
                    break;
                case "phrase":
                    search.Type = YahooJpImageSearch.SearchType.phrase;
                    break;
            }


            // adultOkH
            if (cbAdultOk.Text == "true")
            {
                search.AdultOk = true;
            }
            else if (cbAdultOk.Text == "false")
            {
                search.AdultOk = false;
            }

            // J[
            switch (cbColoration.Text)
            {
                case "any":
                    search.Coloration = YahooJpImageSearch.Color.any;
                    break;
                case "bw":
                    search.Coloration = YahooJpImageSearch.Color.bw;
                    break;
                case "color":
                    search.Coloration = YahooJpImageSearch.Color.color;
                    break;
            }

            // TCg̎w
            if (tbSite.Text != "")
            {
                search.Site = tbSite.Lines;
            }

            YahooJpImageSearchResult searchResult = search.DoSearch(textQuery.Text, int.Parse(cbMaxNum.Text));

            labelTotalNumber.Text = searchResult.TotalResultsAvailable + "";
            labelResultNum.Text = searchResult.TotalResultsReturned + "";


            lvResult.Items.Clear();
            foreach (YahooJpImageElement re in searchResult.ResultElements)
            {
                ListViewItem item = new ListViewItem();
                item.Text = re.Title;
                item.SubItems.Add(re.URL);
                item.SubItems.Add(re.Summary);
                item.SubItems.Add(re.ClickUrl);
                item.SubItems.Add(re.Width.ToString());
                item.SubItems.Add(re.Height.ToString());
                item.SubItems.Add(re.RefererUrl);
                item.SubItems.Add(re.FileSize);
                item.SubItems.Add(re.FileFormat);
                item.SubItems.Add(re.ThumbnailUrl);
                item.SubItems.Add(re.ThumbnailHeight.ToString());
                item.SubItems.Add(re.ThumbnailWidth.ToString());
                item.SubItems.Add(re.Publisher);
                item.SubItems.Add(re.FrameOk.ToString());
                item.SubItems.Add(re.InlineOk.ToString());
                item.SubItems.Add(re.Copyright);

                lvResult.Items.Add(item);
            }
        }
    }
}