using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    public partial class FormYouTube : Form
    {
        public FormYouTube()
        {
            InitializeComponent();
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            YouTubeSearch search;
            search = new YouTubeSearch("vwQ02VPFPD4");

            YouTubeSearchResult result = search.DoSearch(tbQuery.Text, int.Parse(cbMaxNum.Text));

            lblTotalNumber.Text = result.TotalNumber.ToString() + "";
            lblReturned.Text = result.ResultElements.Length.ToString();

            lblQuery.Text = result.Query;

            lvResult.Items.Clear();

            foreach (YouTubeElement element in result.ResultElements)
            {
                ListViewItem item = new ListViewItem(element.Title);
                item.SubItems.Add(element.Description);
                item.SubItems.Add(element.URL);
                item.SubItems.Add(element.ThumbnailURL);
                item.SubItems.Add(element.Author);
                item.SubItems.Add(element.ID);
                item.SubItems.Add(element.Tags);
                item.SubItems.Add(element.LengthSeconds.ToString());
                item.SubItems.Add(element.Date.ToString());

                item.SubItems.Add(element.CommentCount.ToString());
                item.SubItems.Add(element.ViewCount.ToString());
                
                item.SubItems.Add(element.RatingAvg.ToString());
                item.SubItems.Add(element.RatingCount.ToString());
                
                lvResult.Items.Add(item);
            }
        }

        private void lvResult_DoubleClick(object sender, EventArgs e)
        {
            foreach (ListViewItem item in lvResult.SelectedItems)
            {
                System.Diagnostics.Process.Start(item.SubItems[1].Text);
            }
        }
    }
}